% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EventCoverage.R
\name{EventCoverage}
\alias{EventCoverage}
\title{Generate event coverage analysis and visualization for alternative splicing data.}
\usage{
EventCoverage(ZscoreVal, negGene, posGene, binNum, combine = TRUE)
}
\arguments{
\item{ZscoreVal}{A matrix of Z-scores where rows represent genes and columns represent readouts/conditions. This is typically the output from the Zscore() function.}

\item{negGene}{A data frame or matrix containing negative control gene/siRNA identifiers. The first column should contain gene/siRNA names that match the row names in ZscoreVal.}

\item{posGene}{A data frame or matrix containing positive control gene/siRNA identifiers. The first column should contain gene/siRNA names that match the row names in ZscoreVal.}

\item{binNum}{The number of bins to divide the Z-score range. Recommended value is 100. The function creates Z-score thresholds from the 0.00001 to 0.99999 quantiles of the data.}

\item{combine}{Logical. Whether to combine the negative and positive Z-score ranges. Default is TRUE. When TRUE, uses symmetric ranges around zero; when FALSE, uses separate ranges for negative and positive values.}
}
\value{
A list containing two sublists:
  \item{ECdataList}{A list with the following components:
    \itemize{
      \item ZseqList: A data frame with Z-score thresholds for decrease (Zseq_D) and increase (Zseq_I) directions
      \item EC_N_I: Event coverage matrix for negative controls in increase direction
      \item EC_N_D: Event coverage matrix for negative controls in decrease direction
      \item EC_P_I: Event coverage matrix for positive controls in increase direction
      \item EC_P_D: Event coverage matrix for positive controls in decrease direction
    }
  }
  \item{ECplotList}{A list with two ggplot objects:
    \itemize{
      \item EC_jitter_D: Jitter plot showing event coverage for decrease direction
      \item EC_jitter_I: Jitter plot showing event coverage for increase direction
    }
  }
}
\description{
This function analyzes event coverage across Z-score thresholds and generates visualizations to compare positive and negative control samples. It calculates the proportion of readouts that exceed different Z-score thresholds for each gene, creating the foundation for zeta score calculations.
}
\details{
The function performs the following steps:
\enumerate{
  \item Determines Z-score thresholds based on data quantiles and binNum
  \item For each gene and threshold, calculates the proportion of readouts that exceed (increase) or fall below (decrease) the threshold
  \item Separates data into negative and positive control groups
  \item Generates jitter plots comparing event coverage between control groups
  \item Returns both data matrices and visualization plots
}

The event coverage matrices can be used as input for SVM analysis and zeta score calculations.
}
\examples{
data(countMat)
data(negGene)
data(posGene)
ZscoreVal <- Zscore(countMat, negGene)
ECList <- EventCoverage(ZscoreVal, negGene, posGene, binNum=100, combine=TRUE)

}
\author{
Yajing Hao, Shuyang Zhang, Junhui Li, Guofeng Zhao, Xiang-Dong Fu
}
\keyword{ZetaSuite}
\keyword{alternative}
\keyword{coverage}
\keyword{event}
\keyword{splicing}
