% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef.tridim_transformation}
\alias{coef.tridim_transformation}
\title{Posterior distributions for transformation coefficients
in full or summarized form.}
\usage{
\method{coef}{tridim_transformation}(
  object,
  summary = TRUE,
  probs = c(0.055, 0.945),
  convert_euclidean = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class \link[=tridim_transformation-class]{tridim_transformation}.}

\item{summary}{Whether summary statistics should be returned instead of
raw sample values. Defaults to \code{TRUE}}

\item{probs}{The percentiles used to compute summary, defaults to 89\% credible interval.}

\item{convert_euclidean}{Whether to convert matrix coefficients to scale(phi) and rotation(theta). Defaults to \code{FALSE}.}

\item{...}{Unused}
}
\value{
If summary=FALSE, a list with matrix iterationsN x dimensionsN for
each variable.
If summary=TRUE, a data.frame with columns with mean for each
variable plus optional quantiles columns.
}
\description{
Posterior distributions for transformation coefficients
in full or summarized form.
}
\examples{
euc2 <- fit_transformation(depV1+depV2~indepV1+indepV2,
                           data = NakayaData,
                           transformation = 'euclidean')

# full posterior distribution
transform_posterior <- coef(euc2, summary=FALSE)

# coefficients' summary with 89\% CI
coef(euc2)

# scale and rotation coefficients
coef(euc2, convert_euclidean=TRUE)
}
