% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{ADHD_df}
\alias{ADHD_df}
\title{ADHD Symptom Checklist for Children Aged 6–8 Years}
\format{
A data frame with 355 observations and 19 variables:
\describe{
  \item{group}{Group indicator (integer: 1 = ADHD diagnosis, 0 = no diagnosis)}
  \item{avoid}{Avoids tasks requiring sustained mental effort (integer: 0 or 1)}
  \item{closeatt}{Fails to give close attention to details (integer: 0 or 1)}
  \item{distract}{Easily distracted by extraneous stimuli (integer: 0 or 1)}
  \item{forget}{Forgetful in daily activities (integer: 0 or 1)}
  \item{instruct}{Fails to follow through on instructions (integer: 0 or 1)}
  \item{listen}{Does not seem to listen when spoken to directly (integer: 0 or 1)}
  \item{loses}{Loses things necessary for tasks or activities (integer: 0 or 1)}
  \item{org}{Difficulty organizing tasks and activities (integer: 0 or 1)}
  \item{susatt}{Difficulty sustaining attention in tasks or play (integer: 0 or 1)}
  \item{blurts}{Blurts out answers before questions are completed (integer: 0 or 1)}
  \item{fidget}{Fidgets with hands or feet or squirms in seat (integer: 0 or 1)}
  \item{interrupt}{Interrupts or intrudes on others (integer: 0 or 1)}
  \item{motor}{Acts as if driven by a motor (integer: 0 or 1)}
  \item{quiet}{Difficulty playing or engaging quietly in leisure activities (integer: 0 or 1)}
  \item{runs}{Runs about or climbs excessively in inappropriate situations (integer: 0 or 1)}
  \item{seat}{Leaves seat in situations when remaining seated is expected (integer: 0 or 1)}
  \item{talks}{Talks excessively (integer: 0 or 1)}
  \item{turn}{Difficulty waiting turn (integer: 0 or 1)}
}
}
\source{
Data taken from the bgms package version 0.1.6.1
}
\usage{
data(ADHD_df)
}
\description{
This dataset, ADHD_df, is a data frame containing ADHD symptom ratings for 355 children aged 6 to 8 years
from the Children's Attention Project (CAP) cohort (Silk et al. 2019). The sample consists of 146 children
diagnosed with ADHD and 209 without a diagnosis. Symptoms were assessed through structured interviews with
parents using the NIMH Diagnostic Interview Schedule for Children IV (DISC-IV) (Shaffer et al. 2000).
The checklist includes 18 items: 9 Inattentive (I) and 9 Hyperactive/Impulsive (HI). Each symptom item
is binary coded (1 = present, 0 = absent), providing a comprehensive assessment of ADHD symptomatology
in young children.
}
\details{
The dataset name has been kept as ADHD_df to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
NeuroDataSets package and assists users in identifying its specific characteristics.
The suffix df indicates that the dataset is a data frame. The original content has not been modified.
}
