% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_matrix_functions.R
\name{cosinor}
\alias{cosinor}
\title{Evaluate trigonometric basis expansion}
\usage{
cosinor(x = 1:24, period = 24, eval = TRUE)
}
\arguments{
\item{x}{vector of periodic variable values}

\item{period}{vector of period length. For example for time of day \code{period = 24}, or \code{period = c(24,12)} for more flexibility.}

\item{eval}{logical, should not be changed. If \code{TRUE} the function returns the evaluated cosinor terms, if \code{FALSE} the function returns the terms as strings which is used internally form formula evaluation.}
}
\value{
either a desing matrix with the evaluated cosinor terms (\code{eval = TRUE}) or a character vector with the terms as strings (\code{eval = FALSE}).
}
\description{
This function can be used to evaluate a trigonometric basis expansion for a given periodic variable and period. 
It can also be used in formulas passed to \code{\link{make_matrices}}.
}
\details{
The returned basis can be used for linear predictors of the form
\deqn{ 
 \eta^{(t)} = \beta_0 + \sum_{k} \bigl( \beta_{1k} \sin(\frac{2 \pi t}{period_k}) + \beta_{2k} \cos(\frac{2 \pi t}{period_k}) \bigr). 
}
This is relevant for modeling e.g. diurnal variation and the flexibility can be increased by adding smaller frequencies (i.e. increasing the length of \code{period}).
}
\examples{
## Evaluate cosinor terms
# builds design matrix
X = cosinor(1:24, period = 24)
X = cosinor(1:24, period = c(24, 12, 6))

## Usage in model formulas
# e.g. frequencies of 24 and 12 hours + interaction with temperature
form = ~ x + temp * cosinor(hour, c(24, 12)) 
data = data.frame(x = runif(24), temp = rnorm(24,20), hour = 1:24)
modmat = make_matrices(form, data = data)
}
