% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify_mean.R
\name{verify_mean}
\alias{verify_mean}
\title{Verify zero-mean preservation (Theorem 10 assumption 2a)}
\usage{
verify_mean(g_fun, m = 5, n = 10000, tol = 0.001)
}
\arguments{
\item{g_fun}{vectorised map g: R -> R}

\item{m}{latent dimension}

\item{n}{Monte-Carlo sample size}

\item{tol}{numerical tolerance (default 1e-3)}
}
\value{
logical TRUE if |mean| < tol on all coords
}
\description{
Draws n i.i.d. N(0, I_m) latent factors, applies g component-wise,
and checks whether |E[g(x)]| < tol on every coordinate.
}
\examples{
  tmp <- g_fun("weak_nonlinear")
  verify_mean(tmp$g_fun, m = 5)
}
