/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.SVarSet;
import org.rosuda.ibase.toolkit.AWTGraphicsDevice;
import org.rosuda.ibase.toolkit.PlotComponent;
import org.rosuda.ibase.toolkit.QueryPopup;
import org.rosuda.pograss.PoGraSS;
import org.rosuda.util.Global;
import org.rosuda.util.Tools;

public class AwtQueryPopup
extends AWTGraphicsDevice
implements MouseListener,
QueryPopup {
    QPCanvas cvs;
    Window win;
    Window owner;
    PlotComponent pc;

    public AwtQueryPopup(Window window, SVarSet sVarSet, String string, int n, int n2) {
        if (string == null) {
            return;
        }
        this.owner = window;
        if (this.owner == null) {
            this.owner = this.getParentWindow();
        }
        this.win = new Window(this.owner);
        this.cvs = new QPCanvas(this.win, sVarSet, string, n, n2);
        this.win.add(this.cvs.getComponent());
        this.cvs.setSize(100, 50);
        this.win.setBackground(Common.popupColor);
        this.win.addMouseListener(this);
        this.cvs.addMouseListener(this);
        this.win.pack();
    }

    public AwtQueryPopup(Window window, SVarSet sVarSet, String string) {
        this(window, sVarSet, string, -1, -1);
    }

    public Window getParentWindow() {
        Container container;
        for (container = this.cvs.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
        }
        return (Window)container;
    }

    public void setContent(String string, int[] nArray) {
        this.cvs.setContent(string, nArray);
    }

    public void setContent(String string, int n) {
        this.cvs.setContent(string, n);
    }

    public void setContent(String string) {
        this.cvs.setContent(string, -1);
    }

    public void show() {
        if (Global.DEBUG > 0) {
            System.out.println("QueryPopup.show");
        }
        if (!this.win.isVisible()) {
            if (Global.DEBUG > 0) {
                System.out.println("AwtQueryPopup.show: rendering win visible");
            }
            this.win.pack();
            this.win.setVisible(true);
        }
    }

    public void hide() {
        if (this.win.isVisible()) {
            if (Global.DEBUG > 0) {
                System.out.println("AwtQueryPopup.show: hiding win");
            }
            this.win.setVisible(false);
        }
    }

    public void setLocation(int n, int n2) {
        Dimension dimension = this.win.getSize();
        if (n2 + dimension.height + 5 > Common.getScreenRes().height) {
            n2 = Common.screenRes.height - dimension.height - 5;
        }
        if (n + dimension.width + 5 > Common.getScreenRes().width) {
            n = Common.screenRes.width - dimension.width - 5;
        }
        this.win.setLocation(n, n2);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.hide();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.hide();
    }

    public Component getQueryComponent() {
        return this.win;
    }

    class QPCanvas
    extends AWTGraphicsDevice {
        String[] content;
        int width;
        Window win;
        SVarSet vs;
        int topMargin = 8;
        int bottomMargin = 8;
        int leftMargin = 10;
        int rightMargin = 10;
        public boolean doUpdate = true;
        int xh;

        public void paintPoGraSS(PoGraSS poGraSS) {
        }

        public void beginPaint(PoGraSS poGraSS) {
        }

        public void endPaint(PoGraSS poGraSS) {
        }

        QPCanvas(Window window, SVarSet sVarSet, String string, int n, int n2) {
            this.width = n;
            this.win = window;
            this.vs = sVarSet;
        }

        public void setContent(String string, int n) {
            String string2 = string;
            if (this.vs != null && n >= 0) {
                string2 = string2 + " \n";
                for (int i = 0; i < this.vs.count(); ++i) {
                    if (this.vs.at(i) == null || !this.vs.at(i).isSelected()) continue;
                    string2 = string2 + this.vs.at(i).getName() + ": " + this.vs.at(i).atS(n) + "\n";
                }
            }
            this.setContentString(string2);
        }

        public void setContent(String string, int[] nArray) {
            String string2 = string;
            if (this.vs != null && nArray != null && nArray.length > 0) {
                string2 = string2 + "\n";
                boolean bl = true;
                for (int i = 0; i < this.vs.count(); ++i) {
                    int n;
                    if (this.vs.at(i) == null || !this.vs.at(i).isSelected()) continue;
                    if (bl) {
                        bl = false;
                        string2 = string2 + " ";
                    }
                    string2 = string2 + "\n";
                    if (!this.vs.at(i).isNum()) continue;
                    double d = 0.0;
                    double d2 = 0.0;
                    for (n = 0; n < nArray.length; ++n) {
                        if (this.vs.at(i).at(nArray[n]) == null) continue;
                        d += this.vs.at(i).atD(nArray[n]);
                        d2 += 1.0;
                    }
                    if (!(d2 > 0.0)) continue;
                    double d3 = 0.0;
                    double d4 = d / d2;
                    for (n = 0; n < nArray.length; ++n) {
                        if (this.vs.at(i).at(nArray[n]) == null) continue;
                        double d5 = this.vs.at(i).atD(nArray[n]) - d4;
                        d3 += d5 * d5;
                    }
                    string2 = string2 + this.vs.at(i).getName() + ": mean=" + Tools.getDisplayableValue(d / d2) + " sd=" + Tools.getDisplayableValue(Math.sqrt(d3 / d2)) + "\n";
                }
            }
            this.setContentString(string2);
        }

        void setContentString(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            int n = stringTokenizer.countTokens();
            if (n < 1) {
                this.content = new String[1];
                this.content[0] = "";
            } else {
                this.content = new String[n];
                int n2 = 0;
                while (stringTokenizer.hasMoreElements()) {
                    String string2;
                    this.content[n2] = string2 = stringTokenizer.nextToken();
                    ++n2;
                }
            }
            this.doUpdate = true;
            this.setBackground(Common.popupColor);
            this.repaint();
        }

        void updateGeometry(Graphics graphics) {
            if (this.content == null) {
                return;
            }
            int n = this.width;
            FontMetrics fontMetrics = graphics.getFontMetrics();
            this.xh = fontMetrics.getHeight();
            int n2 = this.xh * this.content.length + this.topMargin + this.bottomMargin;
            int n3 = 0;
            for (int i = 0; i < this.content.length; ++i) {
                int n4 = fontMetrics.stringWidth(this.content[i]);
                if (n4 <= n3) continue;
                n3 = n4;
            }
            if (n < 30) {
                n = this.leftMargin + this.rightMargin + n3;
            }
            this.doUpdate = false;
            Dimension dimension = this.getSize();
            if (dimension.width != n || dimension.height != n2) {
                this.setSize(n, n2);
                this.win.setSize(n, n2);
                this.win.pack();
            }
        }

        public void paintLayer(Graphics graphics, int n) {
            if (this.doUpdate) {
                this.updateGeometry(graphics);
            }
            Dimension dimension = this.getSize();
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            int n2 = this.topMargin + this.xh * 3 / 4;
            if (this.content == null) {
                return;
            }
            for (int i = 0; i < this.content.length; ++i) {
                graphics.drawString(this.content[i], this.leftMargin, n2);
                n2 += this.xh;
            }
        }
    }
}

