% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.kunfolding.R
\name{plot.kunfolding}
\alias{plot.kunfolding}
\title{Plot Kemeny equivalent augmented unfolding solution}
\usage{
\method{plot}{kunfolding}(
  x,
  labs = NULL,
  labsrow = NULL,
  main = NULL,
  cols = NULL,
  cexind = 1,
  cexitems = 1,
  pchcol = 15,
  ...
)
}
\arguments{
\item{x}{An object of the class "kunfolding"}

\item{labs}{The labels of the items. Defalut is NULL. If not provided, a sequence "o1,...,on" is printed, with n=number of items}

\item{labsrow}{The labels of the individuals. Defalut is NULL. If not provided, a sequence "1,...,m" is printed, with m=number of individuals}

\item{main}{Main title of the plot. Default NULL}

\item{cols}{Color of the individuals. It must be numeric. Default is NULL (dark gray).}

\item{cexind}{cex of the individuals. Default 1}

\item{cexitems}{cex of the items. defaul 1}

\item{pchcol}{pch parameter for items points. Default 15}

\item{\dots}{System reserved (No specific usage)}
}
\value{
the plot of unfolding solution
}
\description{
Plot the Kemeny equivalent augmented unfolding coming from \code{kunfolding}
}
\examples{
data("breakfast", package="smacof")
unfout <- kunfolding(breakfast)
itemsl <- colnames(breakfast)
plot(unfout,labs=itemsl,cexitems=0.8)

}
\seealso{
\code{\link{kunfolding}},  \code{\link{augmatrix}}
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
\keyword{Unfolding}
