\name{UDesigns_I}
\alias{UDesigns_I}
\title{
Orthogonal Uniform Designs with Two Factors
}
\description{
This series of UDs can be obtained for a composite number of levels, L with always two factors, F. Further, "Excellent" type UDs are Excellent in space-filling with larger number of runs available for L >= 6. On the other hand, "Good" type UDs are good in space-filling and lesser the number of runs, available for L >= 9. Generated designs are UDs under discrete discrepancy measure, as all designs will attain the lower bound value of discrete discrepancy.
}
\usage{
UDesigns_I(levels, type)
}
\arguments{
  \item{levels}{ Any composite number >=6 (if "Excellent") or >=9 (if "Good")}
  \item{type}{ "Excellent" or "Good"}
}
\details{
Type "Excellent" or type "Good" both can exist for a same parameter range. For type "Excellent"  it will require more runs than designs generated by type "Good". But type "Excellent" provides designs which are having more spread than type "Good" series designs.
}
\value{
Returns a uniform designs along with number of factors, levels, runs, maximum absolute correlation (MAC) value and discrete discrepancy measure along with its lower bound value.
}
\author{
Ashutosh Dalal,
Cini Varghese,
Rajender Parsad and
Mohd Harun
}
\examples{
library(CompExpDes)
UDesigns_I(levels=6, type="Excellent")
}
\references{
Fang, K.T. (1980). The uniform design: application of number-theoretic methods in experimental design. Acta Math Appl Sin, 3, 363-372.
}
\keyword{Uniform designs}
\keyword{UD}
\keyword{Discrete Discrepancy}
\keyword{Orthogonal uniform designs}
\keyword{Two factor orthogonal uniform designs}
\keyword{LHD}
\keyword{CompExpDes}
\keyword{Latin Hypercube Designs}
\keyword{Computer Experiments}
\keyword{Space-Filling Designs}