#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
 
#include "XSParseKeyword.h"

static OP *pp_keys(pTHX)
{
	HV *dedupe =  newHV();
	AV* keys = newAV();
        int i, len;
        SV *pk;
        dSP;
        while (TOPs) {
		POPs;
                pk = POPs;
	        if (pk && SvOK(pk) && !hv_exists_ent(dedupe, pk, 0)) {
			hv_store_ent(dedupe, pk, newSViv(1), 0);
			av_push(keys, pk);
		}
	}
        PUSHMARK(sp);
	len = av_len(keys) + 1;
	sortsv(AvARRAY(keys), len, Perl_sv_cmp_locale);
	for (i = 0; i < len; i++) PUSHs(av_shift(keys));
        RETURN;
}

static OP *build_keys(OP *list, OP *(*keys)(pTHX)) {
	list->op_type = OP_CUSTOM;
  	list->op_ppaddr = keys;
	return (OP *)list;
}

static int build_ckeys(pTHX_ OP **out, XSParseKeywordPiece *args[], size_t nargs, void *hookdata)
{
	*out = build_keys(args[0]->op, &pp_keys);
	return KEYWORD_PLUGIN_EXPR;
}

static const struct XSParseKeywordHooks hooks_ckeys = {
	.permit_hintkey = "Syntax::Keyword::Combine::Keys/ckeys",
	.pieces = (const struct XSParseKeywordPieceType []){
		XPK_LISTEXPR_LISTCTX,
		{0}
	},
	.build = &build_ckeys,
};
 
MODULE = Syntax::Keyword::Combine::Keys  PACKAGE = Syntax::Keyword::Combine::Keys
 
BOOT:
  boot_xs_parse_keyword(0.01);
 
  register_xs_parse_keyword("ckeys", &hooks_ckeys, NULL);
