/*
 * This file is part of LibEuFin.
 * Copyright (C) 2024-2025 Taler Systems S.A.

 * LibEuFin is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation; either version 3, or
 * (at your option) any later version.

 * LibEuFin is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General
 * Public License for more details.

 * You should have received a copy of the GNU Affero General Public
 * License along with LibEuFin; see the file COPYING.  If not, see
 * <http://www.gnu.org/licenses/>
 */

package tech.libeufin.nexus.api

import io.ktor.http.*
import io.ktor.server.response.*
import io.ktor.server.routing.*
import tech.libeufin.common.*
import tech.libeufin.common.api.intercept
import tech.libeufin.common.api.apiAuth
import tech.libeufin.nexus.ApiConfig

/** Apply authentication api configuration for a route */
fun Route.auth(cfg: ApiConfig?, callback: Route.() -> Unit): Route {
    val method = cfg?.authMethod
    if (method != null) {
        return apiAuth(method, callback)
    } else {
        return this
    }
}

/** Apply conditional api configuration for a route */
fun Route.conditional(cfg: ApiConfig?, callback: Route.() -> Unit): Route =
    intercept("Conditional", callback) {
        if (cfg == null) {
            throw notImplemented()
        }
    }