/* This file is part of GNU Pies
   Copyright (C) 2009-2026 Sergey Poznyakoff
  
   GNU Pies is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Pies is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Pies.  If not, see <http://www.gnu.org/licenses/>. */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "libpies.h"
#include <stdio.h>
#include <parseopt.h>

static int copyright_year = 2025;
static char gplv3[] = N_("\
\n\
License GPLv3+: GNU GPL version 3 or later <http://gnu.org/licenses/gpl.html>\n\
This is free software: you are free to change and redistribute it.\n\
There is NO WARRANTY, to the extent permitted by law.\n\
\n\
");

void
version_hook (WORDWRAP_FILE wf, struct parseopt *po)
{
  wordwrap_printf(wf, "%s (%s) %s\n",
		  po->po_program_name, PACKAGE_NAME, PACKAGE_VERSION);
  wordwrap_printf(wf, "Copyright %s 2008-%d Sergey Poznyakoff\n",
		  _("(C)"),
		  copyright_year);
  wordwrap_puts(wf, gplv3);
}
