/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.ScreenPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;

class HighlightPoly
extends Highlight {
    private final Poly polygon;

    HighlightPoly(Cell c, Poly p, Color col) {
        super(c, col, false);
        this.polygon = p;
    }

    @Override
    public void showInternalHighlight(EditWindow wnd, Graphics g, long highOffX, long highOffY, boolean onlyHighlight) {
        Color oldColor = null;
        if (this.color != null) {
            oldColor = g.getColor();
            g.setColor(this.color);
        }
        Point2D[] points = this.polygon.getPoints();
        if (this.polygon.getStyle() == Poly.Type.FILLED) {
            int[] xPoints = new int[points.length];
            int[] yPoints = new int[points.length];
            for (int i = 0; i < points.length; ++i) {
                ScreenPoint p = wnd.databaseToScreen(((Point2D)points[i]).getX(), points[i].getY());
                xPoints[i] = p.getIntX();
                yPoints[i] = p.getIntY();
            }
            g.fillPolygon(xPoints, yPoints, points.length);
        } else if (this.polygon.getStyle() == Poly.Type.DISC) {
            long radius = Math.round(((Point2D)points[0]).distance(points[1]) * wnd.getScale());
            ScreenPoint ctr = wnd.databaseToScreen(points[0].getX(), points[0].getY());
            g.fillOval((int)(ctr.getX() - radius), (int)(ctr.getY() - radius), (int)radius * 2, (int)radius * 2);
        } else {
            boolean opened = this.polygon.getStyle() == Poly.Type.OPENED;
            HighlightPoly.drawOutlineFromPoints(wnd, g, points, highOffX, highOffY, opened, false);
        }
        if (oldColor != null) {
            g.setColor(oldColor);
        }
    }
}

