/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:32 EDT
 */

package org.gnu.gtk;
import org.gnu.gdk.Pixbuf;
import org.gnu.glib.Boxed;
public class IconSource extends Boxed 
{
	/**
	 * Construct a new IconSource object.
	 */
	public IconSource() {
		handle = gtk_icon_source_new();
	}
	
	/**
	 * Sets the source filename
	 */
	public void setFilename(String filename) {
		gtk_icon_source_set_filename(handle, filename);
	}
	
	/**
	 * Retrieves the source filename or null if one does not exist.
	 */
	public String getFilename() {
		return gtk_icon_source_get_filename(handle);
	}
	
	/**
	 * Sets the source pixbuf.
	 */
	public void setPixbuf(Pixbuf pixbuf) {
		gtk_icon_source_set_pixbuf(handle, pixbuf.getHandle());
	}
	
	/**
	 * Retrieves the source pixbuf or null if one does not exist.
	 */
	public Pixbuf getPixbuf() {
		int hndl = gtk_icon_source_get_pixbuf(handle);
		if (hndl == 0) {
			return null;
		}
		return new Pixbuf(hndl);
	}
	
	/**
	 * Set the icon size.
	 */
	public void setSize(IconSize iconSize) {
		gtk_icon_source_set_size(handle, iconSize.getValue());
	}
	
	/**
	 * Return the icon size.
	 */
	public IconSize getSize() {
		return IconSize.intern(gtk_icon_source_get_size(handle));
	}
	
	/**
	 * Set the icon state.
	 */
	public void setState(StateType state) {
		gtk_icon_source_set_state(handle, state.getValue());
	}
	
	/**
	 * Return the icon state.
	 */
	public StateType getState() {
		return StateType.intern(gtk_icon_source_get_state(handle));
	}
	
	/**
	 * Set the text direction the icon source is intended to be used
	 * with.
	 */
	public void setDirection(TextDirection direction) {
		gtk_icon_source_set_direction(handle, direction.getValue());
	}
	
	/**
	 * Returns the text direction for the icon source.
	 */
	public TextDirection getDirection() {
		return TextDirection.intern(gtk_icon_source_get_direction(handle));
	}
	
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_icon_source_new ();
    native static final protected int gtk_icon_source_copy (int source);
    native static final protected void gtk_icon_source_free (int source);
    native static final protected void gtk_icon_source_set_filename (int source, String filename);
    native static final protected void gtk_icon_source_set_pixbuf (int source, int pixbuf);
    native static final protected String gtk_icon_source_get_filename (int source);
    native static final protected int gtk_icon_source_get_pixbuf (int source);
    native static final protected void gtk_icon_source_set_direction_wildcarded (int source, 
        boolean setting);
    native static final protected void gtk_icon_source_set_state_wildcarded (int source, boolean 
        setting);
    native static final protected void gtk_icon_source_set_size_wildcarded (int source, boolean 
        setting);
    native static final protected boolean gtk_icon_source_get_size_wildcarded (int source);
    native static final protected boolean gtk_icon_source_get_state_wildcarded (int source);
    native static final protected boolean gtk_icon_source_get_direction_wildcarded (int source);
    native static final protected void gtk_icon_source_set_direction (int source, int direction);
    native static final protected void gtk_icon_source_set_state (int source, int state);
    native static final protected void gtk_icon_source_set_size (int source, int size);
    native static final protected int gtk_icon_source_get_direction (int source);
    native static final protected int gtk_icon_source_get_state (int source);
    native static final protected int gtk_icon_source_get_size (int source);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

