/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gconf;

import java.util.List;

import org.gnu.glib.Boxed;

public class ConfValue extends Boxed {
	
	public ConfValue(ConfValueType type) {
		handle = gconf_value_new(type.getValue());
	}
	
	public ConfValue(int handle) {
		this.handle = handle;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();
		gconf_value_free(handle);
	}
	
	public String getString() {
		return gconf_value_get_string(handle);
	}
	
	public void setString(String theString) {
		gconf_value_set_string(handle, theString);
	}
	
	public int getInt() {
		return gconf_value_get_int(handle);
	}
	
	public void setInt(int theInt) {
		gconf_value_set_int(handle, theInt);
	}
	
	public double getDouble() {
		return gconf_value_get_float(handle);
	}
	
	public void setDouble(double theDouble) {
		gconf_value_set_float(handle, theDouble);
	}
	
	public boolean getBoolean() {
		return gconf_value_get_bool(handle);
	}
	
	public void setBoolean(boolean theBoolean) {
		gconf_value_set_bool(handle, theBoolean);
	}

	public ConfValueType getListType() {
		return ConfValueType.intern(gconf_value_get_list_type(handle));
	}
	
	public void setListType(ConfValueType type) {
		gconf_value_set_list_type(handle, type.getValue());
	}
	
	public List getList() {
		return gconf_value_get_list(handle);
	}
	
	public void setList(List theList) {
		gconf_value_set_list(handle, theList);
	}
	
	public ConfValue getCar() {
		return new ConfValue(gconf_value_get_car(handle));
	}
	
	public void setCar(ConfValue theCar) {
		gconf_value_set_car(handle, theCar.getHandle());
	}
	
	public ConfValue getCdr() {
		return new ConfValue(gconf_value_get_cdr(handle));
	}
	
	public void setCdr(ConfValue theCdr) {
		gconf_value_set_cdr(handle, theCdr.getHandle());
	}
	
	public ConfSchema getSchema() {
		return new ConfSchema(gconf_value_get_schema(handle));
	}
	
	public void setSchema(ConfSchema theSchema) {
		gconf_value_set_schema(handle, theSchema.getHandle());
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return gconf_value_to_string(handle);
	}
	
	/****************************************
	 * BEGINNING OF NATIVE CODE
	 ****************************************/
	native static final protected int gconf_value_new(int type);
	native static final protected int gconf_value_copy(int source);
	native static final protected void gconf_value_free(int value);
	native static final protected String gconf_value_get_string(int value);
	native static final protected int gconf_value_get_int(int value);
	native static final protected double gconf_value_get_float(int value);
	native static final protected int gconf_value_get_list_type(int value);
	native static final protected List gconf_value_get_list(int value);
	native static final protected int gconf_value_get_car(int value);
	native static final protected int gconf_value_get_cdr(int value);
	native static final protected boolean gconf_value_get_bool(int value);
	native static final protected int gconf_value_get_schema(int value);
	native static final protected void gconf_value_set_int(int value, int theInt);
	native static final protected void gconf_value_set_string(int value, String theString);
	native static final protected void gconf_value_set_bool(int value, boolean theBool);
	native static final protected void gconf_value_set_float(int value, double theFloat);
	native static final protected void gconf_value_set_schema(int value, int theSchema);
	native static final protected void gconf_value_set_car(int value, int theCar);
	native static final protected void gconf_value_set_cdr(int value, int theCdr);
	native static final protected void gconf_value_set_list_type(int value, int type);
	native static final protected void gconf_value_set_list(int value, List theList);
	native static final protected String gconf_value_to_string(int value);
	/****************************************
	 * END OF NATIVE CODE
	 ****************************************/
}
