/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.freedesktop.cairo;

import org.gnu.glib.Handle;

/**
 * A Glyph holds information about a single glyph when drawing or measuring
 * text. A font is (in simple terms) a collection of shapes used to draw text. A
 * glyph is one of these shapes. There can be multiple glyphs for a single
 * character (alternates to be used in different contexts, for example), or a
 * glyph can be a <firstterm>ligature</firstterm> of multiple characters. Cairo
 * doesn't expose any way of converting input text into glyphs, so in order to
 * use the Cairo interfaces that take arrays of glyphs, you must directly access
 * the appropriate underlying font system.
 */
public class Glyph extends CairoObject {

    public Glyph() {
        super(alloc());
    }

    public Glyph(long index, double x, double y) {
        super(alloc(index, x, y));
    }

    Glyph(Handle hndl) {
        super(hndl);
    }

    protected void finalize() throws Throwable {
        free(getHandle());
        super.finalize();
    }

    public long getIndex() {
        return get_index(getHandle());
    }

    public void setIndex(long index) {
        set_index(getHandle(), index);
    }

    public double getX() {
        return get_x(getHandle());
    }

    public void setX(double x) {
        set_x(getHandle(), x);
    }

    public double getY() {
        return get_y(getHandle());
    }

    public void setY(double y) {
        set_y(getHandle(), y);
    }

    public Point getPoint() {
        return new Point(get_x(getHandle()), get_y(getHandle()));
    }

    /*
     * native calls
     */
    native static final private Handle alloc();

    native static final private Handle alloc(long index, double x, double y);

    native static final private void free(Handle obj);

    native static final private long get_index(Handle obj);

    native static final private double get_x(Handle obj);

    native static final private double get_y(Handle obj);

    native static final private void set_index(Handle obj, long index);

    native static final private void set_x(Handle obj, double x);

    native static final private void set_y(Handle obj, double y);
}
