/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.freedesktop.cairo;

import org.gnu.glib.Enum;

public class FontSlant extends Enum {
    static final private int _NORMAL = 0;

    static final public FontSlant NORMAL = new FontSlant(_NORMAL);

    static final private int _ITALIC = 1;

    static final public FontSlant ITALIC = new FontSlant(_ITALIC);

    static final private int _OBLIQUE = 2;

    static final public FontSlant OBLIQUE = new FontSlant(_OBLIQUE);

    static final private FontSlant[] theInterned = new FontSlant[] { NORMAL,
            ITALIC, OBLIQUE };

    static private java.util.Hashtable theInternedExtras;

    static final private FontSlant theSacrificialOne = new FontSlant(0);

    static public FontSlant intern(int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        FontSlant already = (FontSlant) theInternedExtras
                .get(theSacrificialOne);
        if (already == null) {
            already = new FontSlant(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private FontSlant(int value) {
        value_ = value;
    }

    public boolean test(FontSlant other) {
        return (value_ & other.value_) == other.value_;
    }
}
