/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <cairo.h>
#include <jg_jnu.h>
#include <stdlib.h>

#ifndef _Included_org_freedesktop_cairo_FontExtents
#define _Included_org_freedesktop_cairo_FontExtents
#include "org_freedesktop_cairo_FontExtents.h"
#ifdef __cplusplus
extern "C" {
#endif


/*
 * Class:     org_freedesktop_cairo_FontExtents
 * Method:    free
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_FontExtents_free
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_font_extents_t *fe;
	
	fe = (cairo_font_extents_t*)getPointerFromHandle(env, obj);
	free(fe);
}

/*
 * Class:     org_freedesktop_cairo_FontExtents
 * Method:    get_ascent
 * Signature: (Lorg/gnu/glib/Handle;)D
 */
JNIEXPORT jdouble JNICALL Java_org_freedesktop_cairo_FontExtents_get_1ascent
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_font_extents_t *fe = (cairo_font_extents_t*)getPointerFromHandle(env, obj);
	return (jdouble)fe->ascent;
}

/*
 * Class:     org_freedesktop_cairo_FontExtents
 * Method:    get_descent
 * Signature: (Lorg/gnu/glib/Handle;)D
 */
JNIEXPORT jdouble JNICALL Java_org_freedesktop_cairo_FontExtents_get_1descent
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_font_extents_t *fe = (cairo_font_extents_t*)getPointerFromHandle(env, obj);
	return (jdouble)fe->descent;
}

/*
 * Class:     org_freedesktop_cairo_FontExtents
 * Method:    get_height
 * Signature: (Lorg/gnu/glib/Handle;)D
 */
JNIEXPORT jdouble JNICALL Java_org_freedesktop_cairo_FontExtents_get_1height
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_font_extents_t *fe = (cairo_font_extents_t*)getPointerFromHandle(env, obj);
	return (jdouble)fe->height;
}

/*
 * Class:     org_freedesktop_cairo_FontExtents
 * Method:    get_max_x_advance
 * Signature: (Lorg/gnu/glib/Handle;)D
 */
JNIEXPORT jdouble JNICALL Java_org_freedesktop_cairo_FontExtents_get_1max_1x_1advance
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_font_extents_t *fe = (cairo_font_extents_t*)getPointerFromHandle(env, obj);
	return (jdouble)fe->max_x_advance;
}

/*
 * Class:     org_freedesktop_cairo_FontExtents
 * Method:    get_max_y_advance
 * Signature: (Lorg/gnu/glib/Handle;)D
 */
JNIEXPORT jdouble JNICALL Java_org_freedesktop_cairo_FontExtents_get_1max_1y_1advance
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_font_extents_t *fe = (cairo_font_extents_t*)getPointerFromHandle(env, obj);
	return (jdouble)fe->max_y_advance;
}

#ifdef __cplusplus
}
#endif
#endif
