/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;
import org.gnu.glib.GObject;

/**
 *
 */
 
public class WindowAttr extends GObject{
	
	public WindowAttr(int handle){
		super(handle);
	}
	
	public String getTitle(){
		return WindowAttr.getTitle(getHandle());
	}
	
	public void setTitle(String title){
		if(title!=null)
			setTitle(getHandle(), title);
	}
	
	// it will change in the future.
	public int getEventMask(){
		return WindowAttr.getEventMask(getHandle());
	}
	
	public void setEventMask(int evtMask){
		setEventMask(getHandle(), evtMask);
	}
	
	public org.gnu.gdk.Point getPosition(){
		int x= WindowAttr.getX(getHandle());
		int y= WindowAttr.getY(getHandle());
		return new org.gnu.gdk.Point(x, y);
	}
	
	public void setPosition(int x, int y){
		setX(getHandle(), x);
		setY(getHandle(), y);
	}
	
	public void setDimension(int width, int height){
		if(width>=0 && height >=0){
			setWidth(getHandle(), width);
			setHeight(getHandle(), height);
		}
	}
	
	public org.gnu.gdk.Dimension getDimension(){
		int width=WindowAttr.getWidth(getHandle());
		int height=WindowAttr.getHeight(getHandle());
		return new org.gnu.gdk.Dimension(width, height);
	}
		
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected String getTitle (int obj);
    native final protected void setTitle (int obj, String title);
    native static final protected int getEventMask (int obj);
    native final protected void setEventMask (int obj, int event_mask);
    native static final protected int getX (int obj);
    native final protected void setX (int obj, int x);
    native static final protected int getY (int obj);
    native final protected void setY (int obj, int y);
    native static final protected int getWidth (int obj);
    native final protected void setWidth (int obj, int width);
    native static final protected int getHeight (int obj);
    native final protected void setHeight (int obj, int height);
    native static final protected int getWclass (int obj);
    native final protected void setWclass (int obj, int wclass);
    native static final protected int getVisual (int obj);
    native final protected void setVisual (int obj, int visual);
    native static final protected int getColormap (int obj);
    native final protected void setColormap (int obj, int colormap);
    native static final protected int getWindowType (int obj);
    native final protected void setWindowType (int obj, int window_type);
    native static final protected int getCursor (int obj);
    native final protected void setCursor (int obj, int cursor);
    native static final protected String getWmclassName (int obj);
    native final protected void setWmclassName (int obj, String wmclass_name);
    native static final protected String getWmclassClass (int obj);
    native final protected void setWmclassClass (int obj, String wmclass_class);
    native static final protected boolean getOverrideRedirect (int obj);
    native final protected void setOverrideRedirect (int obj, boolean override_redirect);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

