/*
 * Java-Gnome Bindings Library
 *
 * * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gnome.event;

/**
 * Listener for the {@link org.gnu.gnome.DruidPage} widget.
 */
public interface DruidPageChangeListener {
	/**
	 * This method is called whenever a DruidPageChange event occurs.
	 * @return (back and next event types) <code>true</code> if this handler
	 * changed the page <br>
	 * (cancel) <code>true</code> if the druid shouldn't exit yet.
	 */
	public boolean druidPageChangeEvent(DruidPageChangeEvent event);

}
