#ifndef lint
static char *RCSid = "$Header$";
#endif
/*
 * util.c - utility routines for "trimlog"
 *
 * David A. Curry
 * SRI International
 * 333 Ravenswood Avenue
 * Menlo Park, CA 94025
 * davy@itstd.sri.com
 *
 * $Log$
 */
#include <sys/param.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <syslog.h>
#include <stdio.h>

extern char	*pname;			/* program name			*/

/*
 * RaiseLimits - increase file size, data size, and stack size limits to
 *		 their maximums.
 */
RaiseLimits()
{
	struct rlimit rlim;

	getrlimit(RLIMIT_FSIZE, &rlim, (struct rlimit *) 0);
	rlim.rlim_cur = rlim.rlim_max;
	setrlimit(RLIMIT_FSIZE, &rlim, (struct rlimit *) 0);

	getrlimit(RLIMIT_STACK, &rlim, (struct rlimit *) 0);
	rlim.rlim_cur = rlim.rlim_max;
	setrlimit(RLIMIT_STACK, &rlim, (struct rlimit *) 0);

	getrlimit(RLIMIT_DATA, &rlim, (struct rlimit *) 0);
	rlim.rlim_cur = rlim.rlim_max;
	setrlimit(RLIMIT_DATA, &rlim, (struct rlimit *) 0);
}

/*
 * SaveStr - save a string in dynamically allocated memory.
 */
char *
SaveStr(s)
char *s;
{
	char *malloc();
	register char *t;

	if ((t = malloc(strlen(s) + 1)) == NULL)
		Fatal("out of memory.\n", 0, 0);

	strcpy(t, s);
	return(t);
}

/*
 * Perror - print an error message from "perror", preceded by the program
 *	    name, str1, and str2.
 */
Perror(str1, str2)
char *str1, *str2;
{
	if (isatty(2)) {
		fprintf(stderr, "%s: ", pname);

		if (str2) {
			fprintf(stderr, "%s: ", str1);
			str1 = str2;
			}

		perror(str1);
	}
	else {
		if (str2)
			syslog(LOG_ERR, "%s: %m", str1);
		else
			syslog(LOG_ERR, "%m");
	}
}

/*
 * Error - print an error message preceded by the program name.
 */
Error(fmt, arg1, arg2)
char *fmt, *arg1, *arg2;
{
	if (isatty(2)) {
		fprintf(stderr, "%s: ", pname);
		fprintf(stderr, fmt, arg1, arg2);
	}
	else {
		syslog(LOG_ERR, fmt, arg1, arg2);
	}
}

/*
 * Fatal - print an error message preceded by the program name and exit.
 */
Fatal(fmt, arg1, arg2)
char *fmt, *arg1, *arg2;
{
	Error(fmt, arg1, arg2);
	exit(1);
}
