#ifndef lint
static char *RCSid = "$Header$";
#endif
/*
 * sendsig.c - the "sendsig" command for "trimlog"
 *
 * David A. Curry
 * SRI International
 * 333 Ravenswood Avenue
 * Menlo Park, CA 94025
 * davy@itstd.sri.com
 *
 * $Log$
 */
#include <sys/param.h>
#include <sys/file.h>
#include <unistd.h>
#include <stdio.h>

/*
 * SendSig - send signal sig to the process id contained in file.
 */
SendSig(file, sig)
char *file;
int sig;
{
	int pid;
	FILE *fp;

	if (access(file, F_OK) < 0)
		return;

	/*
	 * Open the file for reading.
	 */
	if ((fp = fopen(file, "r")) == NULL) {
		Perror(file, "fopen");
		return;
	}

	/*
	 * Read the process id.
	 */
	if (fscanf(fp, "%d", &pid) != 1) {
		Error("%s: no process id found.\n", file, 0);
		fclose(fp);
		return;
	}

	fclose(fp);

	/*
	 * Send the signal.
	 */
	if (kill(pid, sig) < 0) {
		Perror("kill", 0);
		return;
	}

	/*
	 * Wait a moment for the process to handle it.
	 */
	sleep(5);
}
