#ifndef lint
static char *RCSid = "$Header$";
#endif
/*
 * config.c - configuration file routines for "trimlog"
 *
 * David A. Curry
 * SRI International
 * 333 Ravenswood Avenue
 * Menlo Park, CA 94025
 * davy@itstd.sri.com
 *
 * $Log$
 */
#include <stdio.h>
#include "trimlog.h"

/*
 * ReadConfigFile - read the config file and return a linked list of
 *		    commands.
 */
TrimCommand *
ReadConfigFile()
{
	FILE *fp;
	int lineno;
	char buf[BUFSIZ];
	register char *s;
	TrimCommand *malloc();
	register TrimCommand *tc, *ltc;
	static TrimCommand *trimcmds = NULL;

	/*
	 * Open the config file.
	 */
	if ((fp = fopen(CONFIGFILE, "r")) == NULL)
		Fatal("cannot open \"%s\".\n", CONFIGFILE, 0);

	/*
	 * Allocate the head of the linked list.
	 */
	if ((trimcmds = malloc(sizeof(TrimCommand))) == NULL)
		Fatal("not enough memory.\n", 0, 0);

	tc = ltc = trimcmds;
	lineno = 1;

	/*
	 * Until we run out of lines...
	 */
	while (fgets(buf, sizeof(buf), fp) != NULL) {
		s = buf;

		/*
		 * Skip over leading white space.
		 */
		while ((*s == ' ') || (*s == '\t'))
			s++;

		/*
		 * Skip comments and blank lines.
		 */
		if ((*s == '#') || (*s == '\n')) {
			lineno++;
			continue;
		}

		/*
		 * Parse the line.
		 */
		if (ParseLine(s, lineno, tc) < 0)
			continue;

		/*
		 * Get another structure.
		 */
		if ((tc->t_next = malloc(sizeof(TrimCommand))) == NULL)
			Fatal("not enough memory.\n", 0, 0);

		ltc = tc;
		tc = tc->t_next;
	}

	/*
	 * Close the config file.
	 */
	fclose(fp);

	/*
	 * We allocated one too many in the above loop;
	 * get rid of it.
	 */
	if (ltc != tc) {
		free(tc);
		tc = ltc;
	}

	/*
	 * Mark the end of the list and return.
	 */
	tc->t_next = NULL;
	return(trimcmds);
}

/*
 * ParseLine - extract the command, file name, and numeric argument
 *	       from a command line.
 */
ParseLine(line, lineno, tc)
TrimCommand *tc;
int lineno;
char *line;
{
	int param;
	char *SaveStr();
	char cmd[BUFSIZ], file[BUFSIZ];

	/*
	 * Read the command line.
	 */
	if (sscanf(line, "%s %s %d", cmd, file, &param) != 3) {
		Error("%s: line %d: syntax error.\n", CONFIGFILE, lineno);
		return(-1);
	}

	/*
	 * Figure out the command.
	 */
	if (!strcmp(cmd, "sendsig")) {
		tc->t_mode = SENDSIG;
	}
	else if (!strcmp(cmd, "truncate")) {
		tc->t_mode = TRUNCATE;
	}
	else if (!strcmp(cmd, "trimbylines")) {
		tc->t_mode = TRIMBYLINES;
	}
	else if (!strcmp(cmd, "trimbybytes")) {
		tc->t_mode = TRIMBYBYTES;
	}
	else {
		Error("%s: line %d: unknown command.\n", CONFIGFILE, lineno);
		return(-1);
	}

	/*
	 * Save the file name and numeric argument.
	 */
	tc->t_filename = SaveStr(file);
	tc->t_parameter = param;
	return(0);
}
