#ifndef lint
static char *RCSid = "$Header$";
#endif
/*
 * bylines.c - the "trimbylines" command for "trimlog"
 *
 * David A. Curry
 * SRI International
 * 333 Ravenswood Avenue
 * Menlo Park, CA 94025
 * davy@itstd.sri.com
 *
 * $Log$
 */
#include <sys/param.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>

/*
 * TrimByLines - trim file so that it is lines lines long.  We throw away
 *		 the front part of the file, leaving the last lines lines.
 */
TrimByLines(file, lines)
char *file;
int lines;
{
	FILE *fp;
	struct stat st;
	static int *linepos;
	static int nlinepos = 0;
	int *malloc(), *realloc();
	register int c, nl, pos, *lp;

	if (access(file, F_OK) < 0)
		return;

	/*
	 * Open the file for reading.
	 */
	if ((fp = fopen(file, "r")) == NULL) {
		Perror(file, "open");
		return;
	}

	/*
	 * Find out how big the file is.
	 */
	if (fstat(fileno(fp), &st) < 0) {
		Perror(file, "fstat");
		fclose(fp);
		return;
	}

	/*
	 * Allocate enough integers to hold the starting positions
	 * of the last (lines + 1) lines.
	 */
	if (nlinepos < (lines + 1)) {
		if (nlinepos)
			linepos = realloc(linepos, (lines + 1) * sizeof(int));
		else
			linepos = malloc((lines + 1) * sizeof(int));

		if (linepos == NULL)
			Fatal("out of memory.\n", 0, 0);

		nlinepos = lines + 1;
	}

	nl = 0;
	pos = 0;
	lp = linepos;

	/*
	 * First line starts at position 0.
	 */
	*lp++ = 0;

	/*
	 * Now read the whole file, always saving the starting positions
	 * of the last (lines + 1) lines.
	 */
	while ((c = getc(fp)) != EOF) {
		pos++;

		/*
		 * Save position of next line.
		 */
		if (c == '\n') {
			*lp++ = pos;
			nl++;
		}

		/*
		 * Wrap around.
		 */
		if (lp > &linepos[nlinepos - 1])
			lp = linepos;
	}

	/*
	 * Close the file.
	 */
	fclose(fp);

	/*
	 * There aren't lines lines in the file,
	 * so we don't have to do anything.
	 */
	if (nl <= lines)
		return;

	/*
	 * Now, since we know the array contains the positions
	 * of the last (lines + 1) lines, then we also know that
	 * *lp is going to be the position of the first of those
	 * lines.  So, all we need to do is figure the number of
	 * bytes that comprises, which is the size of the file
	 * minus that position, and call TrimByBytes.
	 */
	if (nl < nlinepos)
		lp -= nl;

	TrimByBytes(file, st.st_size - *lp);
}
