#ifndef lint
static char *RCSid = "$Header$";
#endif
/*
 * bybytes.c - "trimbybytes" command for "trimlog"
 *
 * David A. Curry
 * SRI International
 * 333 Ravenswood Avenue
 * Menlo Park, CA 94025
 * davy@itstd.sri.com
 *
 * $Log$
 */
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <unistd.h>
#include <stdio.h>
#include "trimlog.h"

/*
 * TrimByBytes - trim file to bytes bytes.  This throws away the
 *		 front part of the file, leaving the last bytes bytes.
 *		 Truncate throws away the last part of the file leaving
 *		 the first bytes bytes.
 */
TrimByBytes(file, bytes)
char *file;
int bytes;
{
	int fd;
	struct stat st;
	char buf[BIGBUFSIZE];
	register int n, readpos, writepos;

	if (access(file, F_OK) < 0)
		return;

	/*
	 * Open the file for reading and writing.
	 */
	if ((fd = open(file, O_RDWR)) < 0) {
		Perror(file, "open");
		return;
	}

	/*
	 * Find out how big the file is.
	 */
	if (fstat(fd, &st) < 0) {
		Perror(file, "fstat");
		close(fd);
		return;
	}

	/*
	 * If it's less than bytes bytes long,
	 * we don't need to do anything.
	 */
	if (st.st_size <= bytes) {
		close(fd);
		return;
	}

	/*
	 * Now we need to read the last bytes bytes, and
	 * write them at the beginning of the file so
	 * we don't leave a hole.
	 */
	writepos = 0;
	readpos = st.st_size - bytes;

	/*
	 * Seek to the read position.
	 */
	if (lseek(fd, readpos, 0) < 0) {
		Perror(file, "lseek");
		close(fd);
		return;
	}

	/*
	 * Now read to end of file, writing at writepos.
	 */
	while ((n = read(fd, buf, sizeof(buf))) > 0) {
		/*
		 * Move to the current write position.
		 */
		if (lseek(fd, writepos, 0) < 0) {
			Perror(file, "lseek");
			close(fd);
			return;
		}

		/*
		 * Write the data we just read.
		 */
		if (write(fd, buf, n) < 0) {
			Perror(file, "write");
			close(fd);
			return;
		}

		/*
		 * Advance the read and write positions.
		 */
		writepos += n;
		readpos += n;

		/*
		 * Go back to the read position.
		 */
		if (lseek(fd, readpos, 0) < 0) {
			Perror(file, "lseek");
			close(fd);
			return;
		}
	}

	/*
	 * Check for read errors.
	 */
	if (n < 0) {
		Perror(file, "read");
		close(fd);
		return;
	}

	/*
	 * Now that we've copied bytes bytes of data to the
	 * front of the file; truncate the rest of it.
	 */
	if (ftruncate(fd, writepos) < 0)
		Perror(file, "ftruncate");

	/*
	 * Close the file.
	 */
	close(fd);
}
