/*
 *	  Copyright 1997-2000 by the Purdue Research Foundation for CERIAS (the
 *	  Center for Education and Research in Information Assurance and
 *	  Security).  All rights reserved.  This work may be used for
 *	  non-profit educational and research purposes only.  Any copies made
 *	  of this file or portions of its contents must include this copyright
 *	  statement.  For information on reuse, licensing, or copying, contact
 *	  <cerias-info@cerias.purdue.edu>.
 *
 *	  This software is experimental in nature and is provided without any
 *	  express or implied warranties, including, without limitation, the
 *	  implied warranties of merchantability and fitness for any particular
 *	  purpose.
 *
 *        $Id: eventcache.h,v 1.3 2000/01/31 03:56:00 flack Exp $
 *
 * eventcache.h - Chapman Flack, flack@cs.purdue.edu
 *
 * Provides the functions BSM_eventname( e), BSM_eventdesc( e), and
 * BSM_eventclass( e), all of which accept the au_event_t (small integer) e
 * and return the name, description, or class, respectively, of the BSM event e.
 * Depends on vendor routines whose implementations involve file I/O; so, for
 * efficiency, this module caches the results.
 *
 * NOTE (and compare the "Prettyprinting considered harmful" section in the
 * paper) that by using getauevent() to map numeric au_event_t's from the audit
 * log into readable names, this module does not merely transform the data
 * present in the log, but introduces information from the current state
 * (namely the file /etc/security/audit_event) of the system on which the
 * converter is being run. However, unlike the examples of mapping UIDs to
 * login names or IP numbers to domain names, which are expected to vary
 * from host to host and from time to time, the BSM event mappings are expected
 * to be stable enough to perform this transformation without serious risk of
 * changing the meaning of the audit trail.  It is possible to confirm, with an
 * integrity checker, that /etc/security/audit_event has its proper contents,
 * and it might not be unwise to do so before using this program to convert an
 * audit trail of great importance.
 */
#include <jni.h>
#include <sys/param.h>
#include <bsm/libbsm.h>

typedef struct jcache {
  jfieldID kindID;
  jint     kind;
  char const *name;
  }
  jcache;

extern jcache *BSM_eventname( au_event_t num);
extern char const *BSM_eventdesc( au_event_t num);
extern au_class_t BSM_eventclass( au_event_t num);
