package edu.purdue.cerias.projects.BSMParser;

/*
 *	  Copyright 1998-2000 by the Purdue Research Foundation for CERIAS (the
 *	  Center for Education and Research in Information Assurance and
 *	  Security).  All rights reserved.  This work may be used for
 *	  non-profit educational and research purposes only.  Any copies made
 *	  of this file or portions of its contents must include this copyright
 *	  statement.  For information on reuse, licensing, or copying, contact
 *	  <cerias-info@cerias.purdue.edu>.
 *
 *	  This software is experimental in nature and is provided without any
 *	  express or implied warranties, including, without limitation, the
 *	  implied warranties of merchantability and fitness for any particular
 *	  purpose.
 *
 *        $Id: BSMTokenStream.java,v 1.4 2000/01/31 03:56:24 flack Exp $
 *
 *  BSMTokenStream.java - Chapman Flack, flack@cs.purdue.edu
 *
 *  This module reads a Sun BSM audit log provided as a java.io.InputStream
 *  and produces a series of BSMTokens. It implements the ANTLR user TokenStream
 *  interface and feeds the BSMParser generated by ANTLR.
 *
 *  The actual unpacking of the file elements (which are defined in terms of
 *  C-language structs) is done by the native method getNextToken implemented in
 *  BSMTokenStream.c.  The native method has direct access to the structure
 *  definitions in the BSM header files, reducing potential for transcription
 *  error and reducing casting and hacking in Java code.  The native method is
 *  also a good place for transformations of the data that are most easily done
 *  in C, such as breaking up device fields into major and minor and other such
 *  tasks for which system-specific C functions or macros are already provided.
 *
 *  Tokens come back with 'type' values whose symbolic names match the BSM
 *  symbols for token structures, structure members, and event codes.  A token
 *  structure is returned as a sequence of Tokens. The first has type equal to
 *  the name of the structure (e.g. <au_attr_tok_t>) and the subsequent Tokens
 *  have kind tags matching the names of the structure members.  These are
 *  usually in the order of appearance in the struct.
 *
 *  Note the type tags used here match the underlying BSM symbols in name only.
 *  The integer value of the AUE_FORK Token type is not necessarily the same
 *  as the integer value AUE_FORK defined in the BSM header files.  The Token
 *  type values are assigned in sequence by ANTLR and generated into
 *  BSMParserTokenTypes.java. It follows by the way that this token manager will
 *  have difficulty producing a token of a certain kind, unless that name is
 *  mentioned somewhere in the BSMParser input grammar.
 *
 *  Every BSMToken returned by this module is in fact one of five subclasses
 *  Proto, Header, Long, Double, or Block.  Each of the last three has an
 *  instance variable "value" which has Java type long, double, or byte[]
 *  respectively.  Generally speaking, all integral typed members of BSM
 *  structs are returned as Longs, all floating members as Doubles, and strings
 *  or arbitrary data as Blocks.  IP addresses can be returned in string (dotted
 *  quad) representation as BSMBlocks, because this form allows parser action
 *  routines easily to construct java.net.InetAddress objects for use at higher
 *  levels.  Similarly, a device number member is returned as a pair of
 *  BSMLongs (major and minor) because this encoding is system-specific and
 *  should be manipulated only by the vendor-provided C macros.
 */
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;

public class BSMTokenStream implements TokenStream, BSMParserTokenTypes {
  static {
    System.loadLibrary( "BSMTokenStream");
    String efn = System.getProperty( "eventFile");
    if ( efn != null )
      setEventFileName( efn.concat( "\u0000").getBytes());
    initialize( Error.class, java.io.InputStream.class, BSMToken.class,
      BSMScannerException.class, BSMToken.Block.class, BSMToken.Long.class,
      BSMToken.Double.class, BSMToken.Header.class, BSMToken.Proto.class,
      new OutOfMemoryError());
  }
  BSMToken t = new BSMToken.Proto( EOF);
  public Token nextToken() throws TokenStreamException {
    if ( t.next == null ) {
      int lastRecord = record;
      try {
        getNextToken( input, t, buffer, oome);
      }
      catch ( OutOfMemoryError e ) {
        if ( e == oome )
          oome = new OutOfMemoryError();
        throw e;
      }
      for ( BSMToken j = t.next; j != null; j = j.next ) {
        if ( j.record == lastRecord )
          j.position = ++token;
        else {
          lastRecord = j.record;
          j.position = token = 1;
        }
      }
    }
    BSMToken result;
    if ( t.next == null ) {
      t.record = record;
      t.position = ++token;
      result = t;
      t = new BSMToken.Proto( EOF);
      return result;
    }
    result = t.next;
    t.next = result.next;
    result.next = null;
    return result;
  }
  public BSMTokenStream( java.io.InputStream is) {
    if ( is == null )
      throw new Error( "BSMTokenStream constructor passed null InputStream");
    input = is;
  }
  private java.io.InputStream input;
  private byte buffer[] = new byte[ 512 ];
  private OutOfMemoryError oome = new OutOfMemoryError();
  private int record = 0, token = 0;
  private static native void initialize( Class error, Class input,
    Class token, Class lexerr, Class blockCL, Class longCL, Class doubleCL,
    Class headerCL, Class protoCL, OutOfMemoryError memerr);
  private native void getNextToken(
    java.io.InputStream is, Token t, byte[] b, OutOfMemoryError memerr);
  private static native void setEventFileName( byte[] efn);
  
  public static void main( String args[]) {
    java.io.InputStream is;
    for ( int i = 0; i < args.length; ++ i ) {
      try {
      	is = new java.io.FileInputStream( args[i]);
	if ( Boolean.getBoolean( "bufferInput") )
	  is = new java.io.BufferedInputStream( is);
      }
      catch ( java.io.FileNotFoundException e ) {
      	System.err.println( e);
	continue;
      }
      BSMTokenStream bts = new BSMTokenStream( is);
      BSMToken t = null;
 
      System.out.println( args[i]+":");
      for ( ;; ) {
        if ( t == null )
          try {
	    t = (BSMToken)bts.nextToken();
	  }
	  catch ( TokenStreamException e ) {
	    System.out.flush();
	    e.printStackTrace();
	    break;
	  }
        System.out.println( t);
        if ( t.getType() == EOF )
          break;
        t = t.next;
      }
    }
  }
}
