package edu.purdue.cerias.projects.BSMParser;

/*
 *	  Copyright 1999,2000 by the Purdue Research Foundation for CERIAS (the
 *	  Center for Education and Research in Information Assurance and
 *	  Security).  All rights reserved.  This work may be used for
 *	  non-profit educational and research purposes only.  Any copies made
 *	  of this file or portions of its contents must include this copyright
 *	  statement.  For information on reuse, licensing, or copying, contact
 *	  <cerias-info@cerias.purdue.edu>.
 *
 *	  This software is experimental in nature and is provided without any
 *	  express or implied warranties, including, without limitation, the
 *	  implied warranties of merchantability and fitness for any particular
 *	  purpose.
 *
 *        $Id: BSMToken.java,v 1.3 2000/01/31 03:56:24 flack Exp $
 */
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;

public abstract class BSMToken extends antlr.Token {
  static Field[] tokenTypes;
  static int minType;
  static {
    try {
      Class bptt = BSMParserTokenTypes.class;
      tokenTypes = bptt.getDeclaredFields();
      Arrays.sort( tokenTypes, new Comparator() {
      	public int compare( Object o1, Object o2) throws ClassCastException {
	  try {
	    return ((Field)o1).getInt( null) - ((Field)o2).getInt( null);
	  }
	  catch ( IllegalAccessException e ) {
	    throw new RuntimeException( e.toString());
	  }
	}
      });
      int type, lastType, i, delta;
      i = tokenTypes.length - 1;
      lastType = tokenTypes[i].getInt( null);
      for ( --i ; i >= 0; --i ) {
        type = tokenTypes[i].getInt( null);
	delta = lastType - type;
	if ( delta < 1 )
	  throw new Error( "Token types duplicated");
	else if ( delta > 1 ) {
	  Field[] f = new Field[--delta + tokenTypes.length];
	  System.arraycopy( tokenTypes, 0, f, 0, ++i);
	  System.arraycopy( tokenTypes, i, f, i+delta, tokenTypes.length - i);
	  tokenTypes = f;
	  --i;
	}
	lastType = type;
      }
      minType = lastType;
    }
    catch ( RuntimeException t ) { throw t; }
    catch ( Error e ) { throw e; }
    catch ( Exception e ) { throw new RuntimeException( e.toString()); }
  }
  int record, position;
  BSMToken next;
  
  public int getColumn() { return position; }
  public int getLine() { return record; }
  public abstract String getText();
  public void setColumn( int c) { throw new UnsupportedOperationException(); }
  public void setLine( int l) { throw new UnsupportedOperationException(); }
  public void setText( String t) { throw new UnsupportedOperationException(); }
  public void setType( int t) { throw new UnsupportedOperationException(); }
  public String toString() {
    return "("+record+","+position+") <"+
    tokenTypes[getType()-minType].getName()+"> "+getText();
  }
  BSMToken( int t) { super( t); }
  
  public static class Header extends BSMToken {
    Header( int t) { super( t); }
    public long length, time, msec;
    public int emod;
    public short version;
    public String getText() {
      return "length="+length+" time="+time+" msec="+msec+
        " emod=0x"+Integer.toHexString( emod)+" version="+version;
    }
  }
  
  public static class Long extends BSMToken {
    Long( int t) { super( t); }
    public long value;
    public String getText() { return java.lang.Long.toString( value); }
  }
  
  public static class Double extends BSMToken {
    Double( int t) { super( t); }
    public double value;
    public String getText() { return java.lang.Double.toString( value); }
  }
  
  public static class Block extends BSMToken {
    Block( int t) { super( t); }
    public byte[] value;
    public String getText() {
      if ( value == null )
    	return "";
      return new String( value);
    }
  }
  
  public static class Proto extends BSMToken {
    Proto( int t) { super( t); }
    public String getText() { return ""; }
  }
}
