header {
  package edu.purdue.cerias.projects.BSMParser;
  
/*
 *	  Copyright 1998-2000 by the Purdue Research Foundation for CERIAS (the
 *	  Center for Education and Research in Information Assurance and
 *	  Security).  All rights reserved.  This work may be used for
 *	  non-profit educational and research purposes only.  Any copies made
 *	  of this file or portions of its contents must include this copyright
 *	  statement.  For information on reuse, licensing, or copying, contact
 *	  <cerias-info@cerias.purdue.edu>.
 *
 *	  This software is experimental in nature and is provided without any
 *	  express or implied warranties, including, without limitation, the
 *	  implied warranties of merchantability and fitness for any particular
 *
 *        $Id: BSM.g,v 1.4 2000/01/31 03:56:23 flack Exp $
 *
 *  BSM.g - Chapman Flack, flack@cs.purdue.edu
 *
 *  This grammar is the product of an effort to formally document the structure
 *  of audit logs produced by the Solaris Basic Security Module.  We hope that
 *  it is clear enough to read for an understanding of what a BSM log contains;
 *  it can also be compiled (with the language recognition tool
 *  <A HREF="http://www.antlr.org/" TARGET="ANTLR">ANTLR</A>) to produce a
 *  program that can verify that a BSM log file conforms structurally to this
 *  grammar.  (Or vice versa--this grammar was checked by using it to parse
 *  about two megabytes of BSM log data from Solaris 2.6 and earlier, changing
 *  rules where they didn't fit the log data.  Some of the rules you may find
 *  less clear to read were arrived at in that way.)  Programs that do useful
 *  things with BSM logs can be produced by adding semantic actions to this
 *  grammar and compiling it with ANTLR.
 *
 *  This grammar began as a formal restatement of the descriptions in the
 *  <A HREF="12922?" TARGET="BSM">Solaris 2.6 AnswerBook</A>. (Hyperlinks can be
 *  made live by wrapping this grammar with PRE tags in an HTML document giving
 *  BASE HREF="http://docs.sun.com:80/ab2/coll.47.4/SHIELD/@Ab2PageView/".)
 *  Rules taken from the 2.6 docs can be found by searching this grammar for the
 *  string "2.6".  Other rules were added to describe undocumented records
 *  found in sample audit data; they can be found by searching for "//?".
 *  Undocumented rules with only the event-name token on the right-hand side
 *  mean the event name was present in /etc/security/audit_event but our
 *  sample logs contained no examples of the event to flesh out the rule.
 *
 *  After the grammar was written from the published descriptions, ANTLR
 *  identified rules that were ambiguous with 1-token lookahead.  Those
 *  rules were examined, revealing some that could be disambiguated by looking
 *  more than one token ahead, and some that were inherently ambiguous as
 *  described in the published docs.  Those in the first class were augmented
 *  with ANTLR syntactic predicates to resolve the ambiguity.  The inherently
 *  ambiguous rules were made nonambiguous using best guesses at the intent
 *  behind the documentation.  Such rules can be found by searching this
 *  grammar for the string "??" (two question marks).  So many rules were at
 *  first found inherently ambiguous that a new strategy of semantic lookahead
 *  into the contents of "arg" fields had to be introduced (more on this below).
 *  That strategy significantly reduced the number of "??"'s in this file.
 *
 *  Descriptions in the documentation contained a few surprises assumed to be
 *  typographical errors.  The corresponding rules reflect those assumptions and
 *  so are also flagged with "??".
 *
 *  Undetected by ANTLR, but spotted in the course of writing the grammar, were
 *  rules that could be deterministically parsed but presented ambiguities of
 *  interpretation, suggesting places where the documentation was either
 *  incomplete or inaccurate.  To find those rules, search for " ?" (space,
 *  question mark).
 *
 *  Some event records were found to omit fields reasonably desirable for
 *  understanding the events.  Comments with suggested improvements to what
 *  BSM includes in the log contain "?+".
 *
 *  With the formal ambiguities resolved, the grammar was compiled into a
 *  parsing program and run against two megabytes of BSM audit data; rules were
 *  added or modified until the sample data could be parsed without exception.
 *  Rules that were originally taken from the 2.6 documentation, but had to be
 *  modified to accept the sample data, can be found by searching for the
 *  string "2.6+".  Particularly surprising discoveries are flagged with "?!"
 *
 *  To concisely show the changes from the published rule to the empirical one,
 *  a convention was adopted in the use of the ( ... )? notation for optional
 *  elements.  Elements that are "officially" optional in the 2.6 documents
 *  have no spaces setting off the parentheses from the contents: (attr)?
 *  Where the parentheses are set off with spaces, e.g. ( attr )?, the element
 *  in question was either documented as always present but sometimes absent
 *  in sample data, or did not appear in the documentation but was sometimes
 *  present in sample data.  The rule can be compared to the documentation to
 *  determine which is the case; sometimes a comment was added to elaborate.
 *
 *  Only a subset of defined events were encountered in the sample logs.  The
 *  rules that were covered by the sample are marked with "**".
 *
 *  In parsing BSM audit, decisions often have to be made based not only on the
 *  type of the next BSM token, but its contents; many rules are disambiguated
 *  only by verifying the number and descriptive text of an argument
 *  (e.g. arg[3,"cmd"]).  These cases lead to curious lookahead specifications
 *  of the form (arg[3,"cmd"]) => arg[3,"cmd"], which seem superfluous.  The
 *  construct works around ANTLR's (current) inability to determine on its own
 *  when the semantic checks in the arg rule need to be hoisted into a choice
 *  point in an enclosing rule.  Elsewhere, an explicit semantic check
 *  { isArg(3,"cmd") }? is used similarly.
 *
 *  This file contains only parser rules.  Presentation of the binary BSM log
 *  file to the parser as a TokenStream is done by the BSMTokenStream and
 *  related classes included in the distribution with this file. BSMTokenStream
 *  uses native methods to make use of the BSM header and library support,
 *  to avoid introducing errors in reimplementation.  Therefore, a Solaris
 *  system and a C compiler are needed to run a parser built from this grammar
 *  (or a few Solaris files need to be acquired or reimplemented).
 *
 *  To simplify the automated tools that assisted in the production and
 *  verification of this grammar, the symbols used here, for the most part,
 *  are exactly those used in BSM documentation and system files.  This
 *  convention required relaxing ANTLR's usual convention that terminal and
 *  nonterminal symbols are distinguished by upper/lower case.  For this
 *  grammar, the convention is that both kinds of symbol can be any case,
 *  but terminals are prefixed by a % sign.  Terminals and nonterminals are
 *  in separate name spaces so, for example, the right hand side of AUE_EXIT
 *  (the rule) can begin with %AUE_EXIT (the token).  The ANTLR convention is
 *  changed by simply putting a few class files into the classpath ahead of
 *  the ANTLR directory.  They are included in the distribution with this file.
 *
 *  The rules with mixed-case names are those introduced to clarify or
 *  complete this grammar.  The "protected" ones are subrules used only
 *  to simplify other rules.  The AuditLog rule is the one that describes an
 *  entire BSM log file or catenation of such files.  OneAuditFile matches
 *  exactly that.  Event matches one event, Events any number of them (including
 *  zero).  An ANTLR parser can be entered at any non-protected rule, so it is
 *  possible to parse, e.g., a single Event at a time.
 *
 *  The "main" method of the BSMParser class simply tries to parse any number
 *  of BSM audit files in the order of their names on the command line.
 *  Setting the system property bufferInput to true may improve performance.
 *  If parse exceptions are thrown, it may be helpful to recompile this file
 *  with tracing enabled to determine what didn't match.  See the README.
 *
 *  A Java property can be used to specify an audit event file other than
 *  /etc/security/audit_event.  For example, if you are running the parser on
 *  Solaris 2.5.1 but need to parse audit logs from 2.6, get a copy of
 *  /etc/security/audit_event from a 2.6 system and give its name with
 *  -DeventFile= when running the parser.
 */
}

// ANTLR can make a parser in C++ if you change this option and port some code
options { language = "Java"; }

class BSMParser extends Parser;

{
  public static void main( String args[]) {
    java.io.InputStream is;
    for ( int i = 0; i < args.length; ++ i ) {
      try {
    	is = new java.io.FileInputStream( args[i]);
    	if ( Boolean.getBoolean( "bufferInput") )
    	  is = new java.io.BufferedInputStream( is);
      }
      catch ( java.io.FileNotFoundException e ) {
    	System.err.println( e);
    	continue;
      }
      BSMTokenStream bts = new BSMTokenStream( is);
      BSMParser p = new BSMParser( bts);
      try {
    	p.OneAuditFile();
      }
      catch ( Exception e ) {
    	System.err.println( "In "+args[i]+":");
	e.printStackTrace( System.err);
    	continue;
      }
      System.out.println( "Finished with BSM audit log "+args[i]+".");
    }
  }

  boolean isArg( int num, java.lang.String data)
  throws antlr.TokenStreamException {
    Token t;    // arg  :  %au_arg_tok_t  %num  %val  %length  %data  ;
    t = LT( 2); //-------------------------'^`
    if ( ! ( t instanceof BSMToken.Long ) ) return false;
    if ( ((BSMToken.Long)t).value != num ) return false;
    t = LT( 5); //----------------------------------------------'^`
    if ( ! ( t instanceof BSMToken.Block ) ) return false;
    return new String( ((BSMToken.Block)t).value).equals( data);
  }
  
  boolean isNewFile() throws antlr.TokenStreamException {
    Token t;    // file  :  %au_file_tok_t  %time  %msec  %length  %fname  ;
    t = LT( 5); //---------------------------------------------------'^`
    String s = new String( ((BSMToken.Block)t).value);
    return -1 != s.indexOf( ".not_terminated.");
  }
}

AuditLog 
        : ( options { warnWhenFollowAmbig=false; } :
	               {LA( 1) != EOF}? OneAuditFile )* %EOF 
        ;



OneAuditFile
        : ( {!isNewFile()}? file )?
	  Events
	  ( { isNewFile()}? file )?
        ;



Events
      	: ( options { warnWhenFollowAmbig=false; } : Event )*
	;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *             KERNEL-LEVEL GENERATED AUDIT RECORDS BEGIN HERE               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


AUE_ACCEPT //? **
        : %AUE_ACCEPT^ arg[3,"stropen: flag"] sockinet sockinet subj ret
        ;



AUE_ACCESS //<A HREF="14753?#APARECORD-32902" TARGET="BSM">2.6</A> **
        : %AUE_ACCESS^ path (attr)? subj ret 
        ;



AUE_ACCT //<A HREF="14753?#APARECORD-24800" TARGET="BSM">2.6</A>
        : %AUE_ACCT^ ( path (attr)? | arg[1,"accounting off"] ) subj ret 
        ;



AUE_ACLSET //?
        : %AUE_ACLSET^ subj ret 
        ;



AUE_ADJTIME //<A HREF="14753?#APARECORD-21479" TARGET="BSM">2.6</A>
        : %AUE_ADJTIME^ subj ret 
        ;



AUE_ASYNC_DAEMON //?
        : %AUE_ASYNC_DAEMON^ 
        ;



AUE_ASYNC_DAEMON_EXIT //?
        : %AUE_ASYNC_DAEMON_EXIT^ 
        ;



AUE_AUDIT //<A HREF="14753?#APARECORD-36479" TARGET="BSM">2.6</A>
        : %AUE_AUDIT^ subj ret 
        ;



AUE_AUDITON //?
        : %AUE_AUDITON^ 
        ;



AUE_AUDITON_GESTATE //?
        : %AUE_AUDITON_GESTATE^ 
        ;



AUE_AUDITON_GETCAR //<A HREF="14753?#APARECORD-29809" TARGET="BSM">2.6</A>
        : %AUE_AUDITON_GETCAR^ subj ret 
        ;



AUE_AUDITON_GETCLASS //<A HREF="14753?#APARECORD-40174" TARGET="BSM">2.6</A>
        : %AUE_AUDITON_GETCLASS^ subj ret 
        ;



AUE_AUDITON_GETCOND //<A HREF="14753?#APARECORD-34039" TARGET="BSM">2.6</A> **
        : %AUE_AUDITON_GETCOND^ subj ret 
        ;



AUE_AUDITON_GETCWD //<A HREF="14753?#APARECORD-27553" TARGET="BSM">2.6</A>
        : %AUE_AUDITON_GETCWD^ subj ret 
        ;



AUE_AUDITON_GETKMASK //<A HREF="14753?#APARECORD-10731" TARGET="BSM">2.6</A>
        : %AUE_AUDITON_GETKMASK^ subj ret 
        ;



AUE_AUDITON_GETSTAT //<A HREF="14753?#APARECORD-18094" TARGET="BSM">2.6</A>
        : %AUE_AUDITON_GETSTAT^ subj ret 
        ;



AUE_AUDITON_GPOLICY //<A HREF="14753?#APARECORD-23875" TARGET="BSM">2.6</A>
        : %AUE_AUDITON_GPOLICY^ subj ret 
        ;



AUE_AUDITON_GQCTRL //<A HREF="14753?#APARECORD-17137" TARGET="BSM">2.6</A>
        : %AUE_AUDITON_GQCTRL^ subj ret 
        ;



AUE_AUDITON_GTERMID //?
        : %AUE_AUDITON_GTERMID^ 
        ;



AUE_AUDITON_SESTATE //?
        : %AUE_AUDITON_SESTATE^ 
        ;



AUE_AUDITON_SETCLASS //<A HREF="14753?#APARECORD-30789" TARGET="BSM">2.6</A>       what does it mean if a2 or a3 is absent ?
        : %AUE_AUDITON_SETCLASS^
	  ((arg[2,"setclass:ec_event"]) => arg[2,"setclass:ec_event"])?
	  ((arg[3,"setclass:ec_class"]) => arg[3,"setclass:ec_class"])?
	  subj ret 
        ;



AUE_AUDITON_SETCOND //<A HREF="14753?#APARECORD-28604" TARGET="BSM">2.6</A>       what does it mean if a3 is absent ?
        : %AUE_AUDITON_SETCOND^ (arg[3,"setcond"])? subj ret 
        ;



AUE_AUDITON_SETKMASK //<A HREF="14753?#APARECORD-38067" TARGET="BSM">2.6</A>       are these two optionals really a disjunction ?
        : %AUE_AUDITON_SETKMASK^
	  ((arg[2,"setkmask:as_success"]) => arg[2,"setkmask:as_success"])?
	  ((arg[2,"setkmask:as_failure"]) => arg[2,"setkmask:as_failure"])?
	  subj ret 
        ;



AUE_AUDITON_SETSMASK //<A HREF="14753?#APARECORD-22222" TARGET="BSM">2.6</A>       are these two optionals really a disjunction ?
        : %AUE_AUDITON_SETSMASK^
	  ((arg[3,"setsmask:as_success"]) => arg[3,"setsmask:as_success"])?
	  ((arg[3,"setsmask:as_failure"]) => arg[3,"setsmask:as_failure"])?
	  subj ret 
        ;



AUE_AUDITON_SETSTAT //<A HREF="14753?#APARECORD-28706" TARGET="BSM">2.6</A>
        : %AUE_AUDITON_SETSTAT^ subj ret 
        ;



AUE_AUDITON_SETUMASK //<A HREF="14753?#APARECORD-17448" TARGET="BSM">2.6</A>       are these two optionals really a disjunction ?
        : %AUE_AUDITON_SETUMASK^
	  ((arg[3,"setumask:as_success"]) => arg[3,"setumask:as_success"])?
	  ((arg[3,"setumask:as_failure"]) => arg[3,"setumask:as_failure"])?
	  subj ret 
        ;



AUE_AUDITON_SPOLICY //<A HREF="14753?#APARECORD-26700" TARGET="BSM">2.6</A>       what does it mean if a1 is absent ?
        : %AUE_AUDITON_SPOLICY^ (arg[1,"policy"])? subj ret 
        ;



AUE_AUDITON_SQCTRL //<A HREF="14753?#APARECORD-41164" TARGET="BSM">2.6</A>       are these four optionals really a disjunction ?
        : %AUE_AUDITON_SQCTRL^
	  ((arg[3,"setqctrl:aq_hiwater"]) => arg[3,"setqctrl:aq_hiwater"])?
	  ((arg[3,"setqctrl:aq_lowater"]) => arg[3,"setqctrl:aq_lowater"])?
	  ((arg[3,"setqctrl:aq_bufsz"]) => arg[3,"setqctrl:aq_bufsz"])?    
	  ((arg[3,"setqctrl:aq_delay"]) => arg[3,"setqctrl:aq_delay"])?    
	  subj ret
        ;



AUE_AUDITON_STERMID //?
        : %AUE_AUDITON_STERMID^ 
        ;



AUE_AUDITSTAT //?
        : %AUE_AUDITSTAT^ 
        ;



AUE_AUDITSVC //<A HREF="14753?#APARECORD-39760" TARGET="BSM">2.6</A>
// are all four [path][attr] combs possible? meaning ?
        : %AUE_AUDITSVC^ ( arg[1,"no path: fd"] | (path)? (attr)? ) subj ret 
        ;



AUE_AUDITSYS //?
        : %AUE_AUDITSYS^ 
        ;



AUE_BIND //? **
        : %AUE_BIND^ arg[1,"fd"] sockinet subj ret 
        ;



AUE_BSMSYS //?
        : %AUE_BSMSYS^ 
        ;



AUE_CHDIR //<A HREF="14753?#APARECORD-38241" TARGET="BSM">2.6</A> **
        : %AUE_CHDIR^ path (attr)? subj ret 
        ;



AUE_CHMOD //<A HREF="14753?#APARECORD-23440" TARGET="BSM">2.6</A> **
        : %AUE_CHMOD^ arg[2,"new file mode"] path (attr)? subj ret 
        ;



AUE_CHOWN //<A HREF="14753?#APARECORD-18004" TARGET="BSM">2.6</A> **
        : %AUE_CHOWN^
	  arg[2,"new file uid"] arg[3,"new file gid"] path (attr)? subj ret 
        ;



AUE_CHROOT //<A HREF="14753?#APARECORD-15416" TARGET="BSM">2.6</A>
        : %AUE_CHROOT^ path (attr)? subj ret 
        ;



AUE_CLOSE //<A HREF="14753?#APARECORD-20310" TARGET="BSM">2.6+</A> **
// are all four [path][attr] combs possible? meaning ?
        : %AUE_CLOSE^
	  ( (arg[1,"fd"]) => arg[1,"fd"] )? // mandatory in doc, not always here
	  ( (arg[2,"strclose: flag"] CloseLookahead)
	    => arg[2,"strclose: flag"] )?   // not in docs, sometimes here
	  ( { !isArg(2,"strclose: flag") }? ClosePathOrWhatever )?
	  (attr)?
	  ( arg[2,"strclose: flag"] )?      // but then, sometimes it's here
	  subj ret
        ;


protected
CloseLookahead
      	: (arg[2,"strclose: flag"]) => arg[2,"strclose: flag"]
	| attr
	| ClosePathOrWhatever
	;


protected
ClosePathOrWhatever
      	: path
// docs omit the "no path: fp" possibility below.  Shouldn't it be "fd" btw?
	| (arg[1,"no path: fp"]) => arg[1,"no path: fp"]
// I guess someone else wondered the same thing:
	| (arg[1,"no path: fd"]) => arg[1,"no path: fd"]
	;

AUE_CONNECT //? **
      	: %AUE_CONNECT^ ( sockinet | arg[1,"fd"] ) sockinet subj ret
        ;



AUE_CORE //<A HREF="14753?#APARECORD-26823" TARGET="BSM">2.6+</A> **
        : %AUE_CORE^ 
	  ( arg[1,"signal"] )? path (attr)? ( arg[1,"signal"] )? subj ret 
        ;



AUE_CREAT //<A HREF="14753?#APARECORD-39694" TARGET="BSM">2.6</A> **
        : %AUE_CREAT^ path (attr)? subj ret 
        ;



AUE_DOORFS //?
        : %AUE_DOORFS^ 
        ;



AUE_DOORFS_DOOR_BIND //?
        : %AUE_DOORFS_DOOR_BIND^ 
        ;



AUE_DOORFS_DOOR_CALL //? **
        : %AUE_DOORFS_DOOR_CALL^ arg[1,"door ID"] proc subj ret 
        ;



AUE_DOORFS_DOOR_CREATE //?
        : %AUE_DOORFS_DOOR_CREATE^ 
        ;



AUE_DOORFS_DOOR_CRED //?
        : %AUE_DOORFS_DOOR_CRED^ 
        ;



AUE_DOORFS_DOOR_INFO //?
        : %AUE_DOORFS_DOOR_INFO^ 
        ;



AUE_DOORFS_DOOR_RETURN //?
        : %AUE_DOORFS_DOOR_RETURN^ 
        ;



AUE_DOORFS_DOOR_REVOKE //?
        : %AUE_DOORFS_DOOR_REVOKE^ 
        ;



AUE_DOORFS_DOOR_UNBIND //?
        : %AUE_DOORFS_DOOR_UNBIND^ 
        ;



AUE_DUP2 //?
        : %AUE_DUP2^ 
        ;



AUE_ENTERPROM //<A HREF="14753?#APARECORD-19648" TARGET="BSM">2.6</A>
        : %AUE_ENTERPROM^ text/*addr, "monitor prom"|"kadb"*/ subj ret 
        ;



AUE_EXEC //<A HREF="14753?#APARECORD-30258" TARGET="BSM">2.6</A>
        : %AUE_EXEC^ path (attr)? subj ret 
        ;



AUE_EXECVE //<A HREF="14753?#APARECORD-33953" TARGET="BSM">2.6+</A> **
        : %AUE_EXECVE^ path (attr)?
	  ( exec_args ( exec_env )? )?
	  ( arg[2,"strclose: flag"] )? subj ret 
        ;



AUE_EXIT //<A HREF="14753?#APARECORD-11934" TARGET="BSM">2.6+</A> **
        : %AUE_EXIT^ ( ExitExtras )* subj ret 
        ;


protected
ExitExtras // various undocumented things to see in the course of an exit...
      	: (arg[2,"strclose: flag"]) => arg[2,"strclose: flag"] // not shocking
	| (arg[3,"stropen: flag"])  => arg[3,"stropen: flag"]  // stropen ?!
	| (arg[2,"strioctl:vnode"]) => arg[2,"strioctl:vnode"] // strioctl ?!
	;



AUE_EXITPROM //<A HREF="14753?#APARECORD-12791" TARGET="BSM">2.6</A>
        : %AUE_EXITPROM^ text/*addr, "monitor prom"|"kadb"*/ subj ret 
        ;



AUE_EXPORTFS //?
        : %AUE_EXPORTFS^ 
        ;



AUE_FACLSET //?
        : %AUE_FACLSET^ 
        ;



AUE_FCHDIR //<A HREF="14753?#APARECORD-25634" TARGET="BSM">2.6</A>
// are all four [path][attr] combs possible? meaning ?
        : %AUE_FCHDIR^ (path)? (attr)? subj ret 
        ;



AUE_FCHMOD //<A HREF="14753?#APARECORD-32836" TARGET="BSM">2.6</A> **
        : %AUE_FCHMOD^ FchmodChoice subj ret 
        ;


protected
FchmodChoice 
        : ( arg[2,"new file mode"] arg[1,"no path: fd"] ) => FchmodNotValidFD 
        | FchmodValidFD 
        ;


protected
FchmodNotValidFD 
        : arg[2,"new file mode"] arg[1,"no path: fd"] 
        ;


protected
FchmodValidFD // are all four [path][attr] combs possible? meaning ?
        : arg[2,"new file mode"] (path)? (attr)? 
        ;



AUE_FCHOWN //<A HREF="14753?#APARECORD-42234" TARGET="BSM">2.6</A>
        : %AUE_FCHOWN^ FchownChoice subj ret 
        ;


protected
FchownChoice 
        : ( arg[2,"new file uid"] arg[3,"new file gid"] arg[1,"no path: fd"] )
	 => FchownNonFD 
        | FchownValidFD 
        ;


protected
FchownNonFD 
        : arg[2,"new file uid"] arg[3,"new file gid"] arg[1,"no path: fd"] 
        ;


protected
FchownValidFD // are all four [path][attr] combs possible? meaning ?
        : arg[2,"new file uid"] arg[3,"new file gid"] (path)? (attr)? 
        ;



AUE_FCHROOT //<A HREF="14753?#APARECORD-12702" TARGET="BSM">2.6</A>
// are all four [path][attr] combs possible? meaning ?
        : %AUE_FCHROOT^ (path)? (attr)? subj ret 
        ;



AUE_FCNTL //<A HREF="14753?#APARECORD-23719" TARGET="BSM">2.6</A> **
// F_GETLK, F_SETLK, F_SETLKW
        : %AUE_FCNTL^ FcntlChoice subj ret 
        ;


protected
FcntlChoice 
        : ( arg[2,"cmd"] arg[1,"no path: fd"] ) => FcntlBadFD
        | FcntlGoodFD
        ;


protected
FcntlBadFD
        : arg[2,"cmd"] arg[1,"no path: fd"] 
        ;


protected
FcntlGoodFD
        : arg[2,"cmd"] path attr 
        ;



AUE_FLOCK //?
        : %AUE_FLOCK^ 
        ;



AUE_FORK //<A HREF="14753?#APARECORD-18112" TARGET="BSM">2.6</A> **
// what does it mean if a0 is absent ?
        : %AUE_FORK^ (arg[0,"child PID"])? subj ret/*useless*/ 
        ;



AUE_FORK1 //<A HREF="14753?#APARECORD-36618" TARGET="BSM">2.6</A>
// what does it mean if a0 is absent ?
        : %AUE_FORK1^ (arg[0,"child PID"])? subj ret/*useless*/ 
        ;



AUE_FSTAT //?
        : %AUE_FSTAT^ subj ( path )? ( attr )? subj ret 
        ;



AUE_FSTATFS //<A HREF="14753?#APARECORD-41928" TARGET="BSM">2.6</A>
        : %AUE_FSTATFS^ FstatfsChoice subj ret 
        ;


protected
FstatfsChoice 
        : ( arg[1,"no path: fd"] ) => FstatfsNonFD 
        | FstatfsGoodFD 
        ;


protected
FstatfsGoodFD // are all four [path][attr] combs possible? meaning ?
        : (path)? (attr)? 
        ;


protected
FstatfsNonFD 
        : arg[1,"no path: fd"] 
        ;



AUE_FTRUNCATE //?
        : %AUE_FTRUNCATE^ 
        ;



AUE_GETAUDIT //<A HREF="14753?#APARECORD-20034" TARGET="BSM">2.6</A> **
        : %AUE_GETAUDIT^ subj ret 
        ;



AUE_GETAUID //<A HREF="14753?#APARECORD-28488" TARGET="BSM">2.6</A>
        : %AUE_GETAUID^ subj ret 
        ;



AUE_GETDENTS //?
        : %AUE_GETDENTS^ 
        ;



AUE_GETKERNSTATE //?
        : %AUE_GETKERNSTATE^ 
        ;



AUE_GETMSG //<A HREF="14753?#APARECORD-16078" TARGET="BSM">2.6</A> **
        : %AUE_GETMSG^ arg[1,"fd"] arg[4,"pri"] subj ret 
        ;



AUE_GETPMSG //<A HREF="14753?#APARECORD-10620" TARGET="BSM">2.6</A>
        : %AUE_GETPMSG^ arg[1,"fd"] subj ret 
        ;



AUE_GETPORTAUDIT //<A HREF="14753?#APARECORD-39563" TARGET="BSM">2.6</A>
        : %AUE_GETPORTAUDIT^ subj ret 
        ;



AUE_GETUSERAUDIT //?
        : %AUE_GETUSERAUDIT^ 
        ;



AUE_INST_SYNC //?
        : %AUE_INST_SYNC^ 
        ;



AUE_IOCTL //<A HREF="14753?#APARECORD-38975" TARGET="BSM">2.6+</A> **
// extra strioctl:vnode arg
        : %AUE_IOCTL^ IoctlChoice subj ret 
        ;


protected
IoctlChoice
        : IoctlGoodFileDescr 
        | ( arg[1,"fd"] ) => IoctlNonFile
        | ( arg[1,"no path: fd"] ) => IoctlNoName
        | IoctlSocket 
        ;


protected
IoctlGoodFileDescr 
        : path (attr)? arg[2,"cmd"] arg[3,"arg"] ( arg[2,"strioctl:vnode"] )?
        ;


protected
IoctlSocket 
        : (socket)? arg[2,"cmd"] arg[3,"arg"]
        ;


protected
IoctlNonFile 
        : arg[1,"fd"] arg[2,"cmd"] arg[3,"arg"]
        ;


protected
IoctlNoName 
        : arg[1,"no path: fd"] ( attr )? arg[2,"cmd"] arg[3,"arg"]
	  ( arg[2,"strioctl:vnode"] )* // have seen 0, 1, or 2 of these
        ;



AUE_JUNK //?
        : %AUE_JUNK^ 
        ;



AUE_KILL //<A HREF="14753?#APARECORD-12049" TARGET="BSM">2.6</A> **
        : %AUE_KILL^ KillChoice subj ret 
        ;


protected
KillChoice 
        : ( arg[2,"signal"] arg[1,"process"] ) => KillNonPositivePid 
        | KillSpecificProcess 
        ;


protected
KillNonPositivePid 
        : arg[2,"signal"] arg[1,"process"] 
        ;


protected
KillSpecificProcess // no proc included if target didn't exist--
                    // can't find out what process the subject WANTED to kill?+
        : arg[2,"signal"] (proc)? 
        ;



AUE_KILLPG //?
        : %AUE_KILLPG^ 
        ;



AUE_LCHOWN //<A HREF="14753?#APARECORD-25410" TARGET="BSM">2.6</A>
        : %AUE_LCHOWN^
	  arg[2,"new file uid"] arg[3,"new file gid"] path (attr)? subj ret 
        ;



AUE_LINK //<A HREF="14753?#APARECORD-18021" TARGET="BSM">2.6</A> **
        : %AUE_LINK^ from:path (attr)? to:path subj ret 
        ;



AUE_LSEEK //?
        : %AUE_LSEEK^ 
        ;



AUE_LSTAT //<A HREF="14753?#APARECORD-39550" TARGET="BSM">2.6+</A> **
        : %AUE_LSTAT^ ( path )? (attr)? subj ret 
        ;



AUE_LXSTAT //<A HREF="14753?#APARECORD-30049" TARGET="BSM">2.6</A>
        : %AUE_LXSTAT^ path (attr)? subj ret 
        ;



AUE_MCTL //?
        : %AUE_MCTL^ 
        ;



AUE_MEMCNTL //<A HREF="14753?#APARECORD-23826" TARGET="BSM">2.6</A> **
        : %AUE_MEMCNTL^ 
	  arg[1,"base"] arg[2,"len"] arg[3,"cmd"] arg[4,"arg"]
	  arg[5,"attr"] arg[6,"mask"] subj ret 
        ;



AUE_MKDIR //<A HREF="14753?#APARECORD-25623" TARGET="BSM">2.6</A>
        : %AUE_MKDIR^ arg[2,"mode"] path (attr)? subj ret 
        ;



AUE_MKNOD //<A HREF="14753?#APARECORD-34042" TARGET="BSM">2.6</A> **
        : %AUE_MKNOD^ arg[2,"mode"] arg[3,"dev"] path (attr)? subj ret 
        ;



AUE_MMAP //<A HREF="14753?#APARECORD-11936" TARGET="BSM">2.6</A>
        : %AUE_MMAP^ arg[1,"addr"] arg[2,"len"] MmapChoice subj ret 
        ;


protected
MmapChoice 
        : MmapNotValidFD 
        | MmapValidFD 
        ;


protected
MmapNotValidFD 
        : arg[1,"no path: fd"] 
        ;


protected
MmapValidFD // are all four [path][attr] combs possible? meaning ?
        : (path)? (attr)? 
        ;



AUE_MODADDMAJ //<A HREF="14753?#APARECORD-10521" TARGET="BSM">2.6??</A>
// the description "[text] (driver major number) [text] (driver name) text text"
// leads to a formal ambiguity if an event record has exactly three text tokens
// following the header.  It is clear in that case that one of the two optional
// text tokens is present, but the parser cannot determine whether it is the
// (driver major number) or the (driver name).  The ambiguity cannot be resolved
// unless there is a way to tell decisively by looking at the text string
// whether it is a driver major number or a driver name.  One might assume the
// number will always be a text string of only digits and the name will begin
// with a non-digit, but this should be stated explicitly in the BSM docs if
// parsing programs are expected to depend on it.  Or, perhaps the docs are
// mistaken in showing the number and name as being independently optional:
// maybe it should be "[text text] text text"--the first two are either both
// there or both absent.  If that's the case, the docs should be corrected. The
// rule below assumes this interpretation ([text text] text text) which is
// reasonable and conservative under the circumstances.  It will work if they
// are both present, it will work if they are both absent, and, if an instance
// is ever encountered of the ambiguous case with one of the two present, a
// parse exception will be thrown, avoiding a possible undetected
// misinterpretation.
        : %AUE_MODADDMAJ^
	  ( ( text text text ) => text text )?
	  text text arg[5,""] ( text )* subj ret 
        ;



AUE_MODCONFIG //<A HREF="14753?#APARECORD-17540" TARGET="BSM">2.6</A>
        : %AUE_MODCONFIG^ text text subj ret 
        ;



AUE_MODCTL //?
        : %AUE_MODCTL^ 
        ;



AUE_MODLOAD //<A HREF="14753?#APARECORD-10354" TARGET="BSM">2.6</A>
        : %AUE_MODLOAD^ ( ( text text ) => text )? text subj ret 
        ;



AUE_MODUNLOAD //<A HREF="14753?#APARECORD-15608" TARGET="BSM">2.6</A>
        : %AUE_MODUNLOAD^ arg[1,"id"] subj ret 
        ;



AUE_MOUNT //<A HREF="14753?#APARECORD-37077" TARGET="BSM">2.6</A>
        : %AUE_MOUNT^ MountChoice 
        ;


protected
MountChoice 
        : ( arg[3,"flags"] text path ) => MountUNIX 
        | MountNFS 
        ;


protected
MountUNIX 
        : arg[3,"flags"] fstype:text path (attr)? subj ret 
        ;


protected
MountNFS // no subj ret ?
        : arg[3,"flags"] fstype:text host:text arg[3,"internal flags"] 
        ;



AUE_MSGCTL //?
        : %AUE_MSGCTL^ 
        ;



AUE_MSGCTL_RMID //<A HREF="14753?#APARECORD-36313" TARGET="BSM">2.6</A>
// what ipc_perm ?
        : %AUE_MSGCTL_RMID^ arg[1,"msg ID"] (ipc)? subj ret 
        ;



AUE_MSGCTL_SET //<A HREF="14753?#APARECORD-18400" TARGET="BSM">2.6</A>
// what ipc_perm ?
        : %AUE_MSGCTL_SET^ arg[1,"msg ID"] (ipc)? subj ret 
        ;



AUE_MSGCTL_STAT //<A HREF="14753?#APARECORD-20902" TARGET="BSM">2.6</A>
// what ipc_perm ?
        : %AUE_MSGCTL_STAT^ arg[1,"msg ID"] (ipc)? subj ret 
        ;



AUE_MSGGET //<A HREF="14753?#APARECORD-14504" TARGET="BSM">2.6</A>
// what ipc_perm ?
        : %AUE_MSGGET^ (ipc)? subj ret 
        ;



AUE_MSGGETL //?
        : %AUE_MSGGETL^ 
        ;



AUE_MSGRCV //<A HREF="14753?#APARECORD-35926" TARGET="BSM">2.6</A>
// what ipc_perm ?
        : %AUE_MSGRCV^ arg[1,"msg ID"] (ipc)? subj ret 
        ;



AUE_MSGRCVL //?
        : %AUE_MSGRCVL^ 
        ;



AUE_MSGSND //<A HREF="14753?#APARECORD-15049" TARGET="BSM">2.6</A>
// what ipc_perm ?
        : %AUE_MSGSND^ arg[1,"msg ID"] (ipc)? subj ret 
        ;



AUE_MSGSNDL //?
        : %AUE_MSGSNDL^ 
        ;



AUE_MSGSYS //?
        : %AUE_MSGSYS^ 
        ;



AUE_MUNMAP //<A HREF="14753?#APARECORD-16688" TARGET="BSM">2.6</A> **
        : %AUE_MUNMAP^ arg[1,"addr"] arg[2,"len"] subj ret 
        ;



AUE_NFS //?
        : %AUE_NFS^ 
        ;



AUE_NFSSVC_EXIT //?
        : %AUE_NFSSVC_EXIT^ 
        ;



AUE_NFS_GETFH //?
        : %AUE_NFS_GETFH^ 
        ;



AUE_NFS_SVC //?
        : %AUE_NFS_SVC^ 
        ;



AUE_NICE //<A HREF="14753?#APARECORD-27425" TARGET="BSM">2.6</A> **
// wouldn't it be nice to know what niceness was requested?+
        : %AUE_NICE^ subj ret 
        ;



AUE_NULL //?
        : %AUE_NULL^ 
        ;



AUE_PROCESSOR_BIND //?
        : %AUE_PROCESSOR_BIND^ 
        ;



AUE_P_ONLINE //?
        : %AUE_P_ONLINE^ 
        ;



AUE_ONESIDE //?
        : %AUE_ONESIDE^ 
        ;



AUE_OPEN //?
        : %AUE_OPEN^ 
        ;



AUE_OPEN_R //<A HREF="14753?#APARECORD-21847" TARGET="BSM">2.6+</A> **
        : %AUE_OPEN_R^  ( (arg[3,"stropen: flag"]) => arg[3,"stropen: flag"] )?
	  ( { isArg(2,"strclose: flag") }? arg[2,"strclose: flag"] )* // close?!
	  path (attr)? ( arg[3,"stropen: flag"] )? subj ret 
        ;



AUE_OPEN_RC //<A HREF="14753?#APARECORD-38829" TARGET="BSM">2.6</A> **
        : %AUE_OPEN_RC^ path (attr)? subj ret 
        ;



AUE_OPEN_RT //<A HREF="14753?#APARECORD-36884" TARGET="BSM">2.6</A>
        : %AUE_OPEN_RT^ path (attr)? subj ret 
        ;



AUE_OPEN_RTC //<A HREF="14753?#APARECORD-39886" TARGET="BSM">2.6</A>
        : %AUE_OPEN_RTC^ path (attr)? subj ret 
        ;



AUE_OPEN_RW //<A HREF="14753?#APARECORD-24360" TARGET="BSM">2.6+</A> **
        : %AUE_OPEN_RW^ ( arg[3,"stropen: flag"] )?
	  path (attr)? ( arg[3,"stropen: flag"] )? subj ret 
        ;



AUE_OPEN_RWC //<A HREF="14753?#APARECORD-36466" TARGET="BSM">2.6</A> **
        : %AUE_OPEN_RWC^ path (attr)? subj ret 
        ;



AUE_OPEN_RWT //<A HREF="14753?#APARECORD-34437" TARGET="BSM">2.6</A> **
        : %AUE_OPEN_RWT^ path (attr)? subj ret 
        ;



AUE_OPEN_RWTC //<A HREF="14753?#APARECORD-42331" TARGET="BSM">2.6</A> **
        : %AUE_OPEN_RWTC^ path (attr)? subj ret 
        ;



AUE_OPEN_W //<A HREF="14753?#APARECORD-42329" TARGET="BSM">2.6+</A> **
        : %AUE_OPEN_W^  ( arg[3,"stropen: flag"] )?
	  path (attr)? ( arg[3,"stropen: flag"] )? subj ret 
        ;



AUE_OPEN_WC //<A HREF="14753?#APARECORD-39609" TARGET="BSM">2.6</A> **
        : %AUE_OPEN_WC^ path (attr)? subj ret 
        ;



AUE_OPEN_WT //<A HREF="14753?#APARECORD-30474" TARGET="BSM">2.6+</A> **
        : %AUE_OPEN_WT^ ( arg[3,"stropen: flag"] )?
	  path (attr)? ( arg[3,"stropen: flag"] )? subj ret 
        ;



AUE_OPEN_WTC //<A HREF="14753?#APARECORD-29799" TARGET="BSM">2.6</A> **
        : %AUE_OPEN_WTC^ path (attr)? subj ret 
        ;



AUE_OSETPGRP //?
        : %AUE_OSETPGRP^ 
        ;



AUE_OSETUID //<A HREF="14753?#APARECORD-21076" TARGET="BSM">2.6</A> **
        : %AUE_OSETUID^ arg[1,"uid"] subj ret 
        ;



AUE_OSTAT //?
        : %AUE_OSTAT^ 
        ;



AUE_PATHCONF //<A HREF="14753?#APARECORD-37277" TARGET="BSM">2.6</A> **
        : %AUE_PATHCONF^ path (attr)? subj ret 
        ;



AUE_PIPE //<A HREF="14753?#APARECORD-23823" TARGET="BSM">2.6</A>
// why not reveal what FDs were assigned to the pipe?+
        : %AUE_PIPE^ subj ret 
        ;



AUE_PRIOCNTLSYS //<A HREF="14753?#APARECORD-41948" TARGET="BSM">2.6</A>
        : %AUE_PRIOCNTLSYS^ arg[1,"pc_version"] arg[3,"cmd"] subj ret 
        ;



AUE_PUTMSG //<A HREF="14753?#APARECORD-34898" TARGET="BSM">2.6</A> **
        : %AUE_PUTMSG^ arg[1,"fd"] arg[4,"pri"] subj ret 
        ;



AUE_PUTPMSG //<A HREF="14753?#APARECORD-11090" TARGET="BSM">2.6+</A> **
        : %AUE_PUTPMSG^ arg[1,"fd"] ( arg[4,"pri"] arg[5,"flags"] )? subj ret 
        ;



AUE_QUOTACTL //?
        : %AUE_QUOTACTL^ 
        ;



AUE_READ //?
        : %AUE_READ^ 
        ;



AUE_READL //?
        : %AUE_READL^ 
        ;



AUE_READLINK //<A HREF="14753?#APARECORD-19965" TARGET="BSM">2.6</A> **
        : %AUE_READLINK^ path (attr)? subj ret 
        ;



AUE_READV //?
        : %AUE_READV^ 
        ;



AUE_READVL //?
        : %AUE_READVL^ 
        ;



AUE_REBOOT //?
        : %AUE_REBOOT^ 
        ;



AUE_RECV //?
        : %AUE_RECV^ 
        ;



AUE_RECVFROM //?
        : %AUE_RECVFROM^ 
        ;



AUE_RECVMSG //?
        : %AUE_RECVMSG^ 
        ;



AUE_RENAME //<A HREF="14753?#APARECORD-37511" TARGET="BSM">2.6+</A> **
// second path absent iff first path resolution failed??
// should it be more like path (attr path (attr)?)?  ?
        : %AUE_RENAME^ path (attr)? (path ( attr )?)? subj ret 
        ;



AUE_RFSSYS //?
        : %AUE_RFSSYS^ 
        ;



AUE_RMDIR //<A HREF="14753?#APARECORD-42544" TARGET="BSM">2.6</A>
        : %AUE_RMDIR^ path (attr)? subj ret 
        ;



AUE_SEMCTL //?
        : %AUE_SEMCTL^ 
        ;



AUE_SEMCTL_GETALL //<A HREF="14753?#APARECORD-39592" TARGET="BSM">2.6</A>
// what ipc_perm ?
        : %AUE_SEMCTL_GETALL^ arg[1,"sem ID"] (ipc)? subj ret 
        ;



AUE_SEMCTL_GETNCNT //<A HREF="14753?#APARECORD-15737" TARGET="BSM">2.6</A>
// what ipc_perm ?
        : %AUE_SEMCTL_GETNCNT^ arg[1,"sem ID"] (ipc)? subj ret 
        ;



AUE_SEMCTL_GETPID //<A HREF="14753?#APARECORD-16604" TARGET="BSM">2.6</A>
// what ipc_perm ?
        : %AUE_SEMCTL_GETPID^ arg[1,"sem ID"] (ipc)? subj ret 
        ;



AUE_SEMCTL_GETVAL //<A HREF="14753?#APARECORD-29416" TARGET="BSM">2.6</A>
// what ipc_perm ?
        : %AUE_SEMCTL_GETVAL^ arg[1,"sem ID"] (ipc)? subj ret 
        ;



AUE_SEMCTL_GETZCNT //<A HREF="14753?#APARECORD-38012" TARGET="BSM">2.6</A>
// what ipc_perm ?
        : %AUE_SEMCTL_GETZCNT^ arg[1,"sem ID"] (ipc)? subj ret 
        ;



AUE_SEMCTL_RMID //<A HREF="14753?#APARECORD-11971" TARGET="BSM">2.6</A>
// what ipc_perm ?
        : %AUE_SEMCTL_RMID^ arg[1,"sem ID"] (ipc)? subj ret 
        ;



AUE_SEMCTL_SET //<A HREF="14753?#APARECORD-16647" TARGET="BSM">2.6</A>
// what ipc_perm ?
        : %AUE_SEMCTL_SET^ arg[1,"sem ID"] (ipc)? subj ret 
        ;



AUE_SEMCTL_SETALL //<A HREF="14753?#APARECORD-10863" TARGET="BSM">2.6</A>
// what ipc_perm ?
        : %AUE_SEMCTL_SETALL^ arg[1,"sem ID"] (ipc)? subj ret 
        ;



AUE_SEMCTL_SETVAL //<A HREF="14753?#APARECORD-26791" TARGET="BSM">2.6</A>
// what ipc_perm ?
        : %AUE_SEMCTL_SETVAL^ arg[1,"sem ID"] (ipc)? subj ret 
        ;



AUE_SEMCTL_STAT //<A HREF="14753?#APARECORD-11271" TARGET="BSM">2.6</A>
        : %AUE_SEMCTL_STAT^ arg[1,"sem ID" ] (ipc)? subj ret 
        ;



AUE_SEMGET //<A HREF="14753?#APARECORD-13142" TARGET="BSM">2.6</A>
// what ipc_perm ?
        : %AUE_SEMGET^ (ipc)? subj ret 
        ;



AUE_SEMGETL //?
        : %AUE_SEMGETL^ 
        ;



AUE_SEMOP //<A HREF="14753?#APARECORD-27240" TARGET="BSM">2.6</A>
// can't see the requested operations?+
        : %AUE_SEMOP^ arg[1,"sem ID"] (ipc)? subj ret 
        ;



AUE_SEMSYS //?
        : %AUE_SEMSYS^ 
        ;



AUE_SEND //?
        : %AUE_SEND^ 
        ;



AUE_SENDMSG //?
        : %AUE_SENDMSG^ 
        ;



AUE_SENDTO //?
        : %AUE_SENDTO^ 
        ;



AUE_SETAUDIT //<A HREF="14753?#APARECORD-29060" TARGET="BSM">2.6</A> **
// should these args really all be numbered 1 ?
        : %AUE_SETAUDIT^
	  ( arg[1,"setaudit:auid"]
	    arg[1,"setaudit:port"]
	    arg[1,"setaudit:machine"]
	    arg[1,"setaudit:as_success"]
	    arg[1,"setaudit:as_failure"]
	    arg[1,"setaudit:asid"]
	  )?  // present iff program stack address valid
	  subj ret 
        ;



AUE_SETAUID //<A HREF="14753?#APARECORD-41901" TARGET="BSM">2.6</A>
        : %AUE_SETAUID^ arg[2,"setauid"] subj ret 
        ;



AUE_SETDOMAINNAME 
        : %AUE_SETDOMAINNAME^ 
        ;



AUE_SETEGID //<A HREF="14753?#APARECORD-28205" TARGET="BSM">2.6</A>
        : %AUE_SETEGID^ arg[1,"gid"] subj ret 
        ;



AUE_SETEUID //<A HREF="14753?#APARECORD-29030" TARGET="BSM">2.6??</A>
// docs say arg text is "gid", I'm guessing that's a typo ??
        : %AUE_SETEUID^ arg[1,"uid"] subj ret 
        ;



AUE_SETGID //<A HREF="14753?#APARECORD-18414" TARGET="BSM">2.6</A> **
        : %AUE_SETGID^ arg[1,"gid"] subj ret 
        ;



AUE_SETGROUPS //<A HREF="14753?#APARECORD-24001" TARGET="BSM">2.6</A> **
        : %AUE_SETGROUPS^ ( arg[1,"setgroups"] )+ subj ret 
        ;



AUE_SETHOSTNAME //?
        : %AUE_SETHOSTNAME^ 
        ;



AUE_SETKERNSTATE //?
        : %AUE_SETKERNSTATE^ 
        ;



AUE_SETPGRP //<A HREF="14753?#APARECORD-38206" TARGET="BSM">2.6</A> **
        : %AUE_SETPGRP^ subj ret 
        ;



AUE_SETPRIORITY //?
        : %AUE_SETPRIORITY^ 
        ;



AUE_SETREGID //?
        : %AUE_SETREGID^ 
        ;



AUE_SETREUID //?
        : %AUE_SETREUID^ 
        ;



AUE_SETRLIMIT //<A HREF="14753?#APARECORD-16443" TARGET="BSM">2.6</A> **
// what resource?+ what limit?+
        : %AUE_SETRLIMIT^ subj ret 
        ;



AUE_SETSOCKOPT //? **
        : %AUE_SETSOCKOPT^ sockinet
	  arg[2,"level"] arg[3,"optname"] arg[4,"optval"] arg[5,"optlen"]
	  subj ret 
        ;



AUE_SETTIMEOFDAY //?
        : %AUE_SETTIMEOFDAY^ 
        ;



AUE_SETUSERAUDIT //?
        : %AUE_SETUSERAUDIT^ 
        ;



AUE_SHMAT //<A HREF="14753?#APARECORD-17414" TARGET="BSM">2.6</A>
// does note imply ipc and ipc_perm should be JOINTLY, not INDIVIDUALLY,
// optional ?
        : %AUE_SHMAT^
	  arg[1,"shmid"] arg[2,"shmaddr"] (ipc)? (ipc_perm)? subj ret 
        ;



AUE_SHMCTL //?
        : %AUE_SHMCTL^ 
        ;



AUE_SHMCTL_RMID //<A HREF="14753?#APARECORD-20430" TARGET="BSM">2.6</A>
// what ipc_perm ?
        : %AUE_SHMCTL_RMID^ arg[1,"shmid"] (ipc)? subj ret 
        ;



AUE_SHMCTL_SET //<A HREF="14753?#APARECORD-27211" TARGET="BSM">2.6</A>
// does note imply ipc and ipc_perm should be JOINTLY, not INDIVIDUALLY,
// optional ?
        : %AUE_SHMCTL_SET^ arg[1,"shmid"] (ipc)? (ipc_perm)? subj ret 
        ;



AUE_SHMCTL_STAT //<A HREF="14753?#APARECORD-37686" TARGET="BSM">2.6</A>
// what ipc_perm ?
        : %AUE_SHMCTL_STAT^ arg[1,"shmid"] (ipc)? subj ret 
        ;



AUE_SHMDT //<A HREF="14753?#APARECORD-12661" TARGET="BSM">2.6</A>
        : %AUE_SHMDT^ arg[1,"shmaddr"] subj ret 
        ;



AUE_SHMGET //<A HREF="14753?#APARECORD-14872" TARGET="BSM">2.6</A>
// does note imply ipc and ipc_perm should be JOINTLY, not INDIVIDUALLY,
// optional?
        : %AUE_SHMGET^ arg[0,"shmid"] (ipc)? (ipc_perm)? subj ret 
        ;



AUE_SHMGETL //?
        : %AUE_SHMGETL^ 
        ;



AUE_SHMSYS //?
        : %AUE_SHMSYS^ 
        ;



AUE_SHUTDOWN //?
        : %AUE_SHUTDOWN^ 
        ;



AUE_SOCKACCEPT //<A HREF="14753?#APARECORD-28890" TARGET="BSM">2.6</A>
        : %AUE_SOCKACCEPT^ sockinet arg[1,"fd"] arg[4,"pri"] subj ret 
        ;



AUE_SOCKCONNECT //<A HREF="14753?#APARECORD-26898" TARGET="BSM">2.6+</A> **
// docs say sockinet before args
        : %AUE_SOCKCONNECT^ arg[1,"fd"] arg[4,"pri"] sockinet subj ret 
        ;



AUE_SOCKET //? **
        : %AUE_SOCKET^
	  arg[1,"domain"] arg[2,"type"] arg[3,"protocol"] arg[3,"stropen: flag"]
	  subj ret 
        ;



AUE_SOCKETPAIR //?
        : %AUE_SOCKETPAIR^ 
        ;



AUE_SOCKRECEIVE //<A HREF="14753?#APARECORD-27275" TARGET="BSM">2.6</A>
        : %AUE_SOCKRECEIVE^ sockinet arg[1,"fd"] arg[4,"pri"] subj ret 
        ;



AUE_SOCKSEND //<A HREF="14753?#APARECORD-16620" TARGET="BSM">2.6</A>
        : %AUE_SOCKSEND^ sockinet arg[1,"fd"] arg[4,"pri"] subj ret 
        ;



AUE_STAT //<A HREF="14753?#APARECORD-18039" TARGET="BSM">2.6+</A> **
        : %AUE_STAT^ ( StatExtras )* path (attr)? subj ret 
        ;


protected
StatExtras
      	: (arg[3,"stropen: flag"])  => arg[3,"stropen: flag"]
	| (arg[2,"strioctl:vnode"]) => arg[2,"strioctl:vnode"]
	;



AUE_STATFS //<A HREF="14753?#APARECORD-37756" TARGET="BSM">2.6</A>
        : %AUE_STATFS^ path (attr)? subj ret 
        ;



AUE_STATVFS //<A HREF="14753?#APARECORD-35455" TARGET="BSM">2.6</A>
        : %AUE_STATVFS^ path (attr)? subj ret 
        ;



AUE_STIME //<A HREF="14753?#APARECORD-39949" TARGET="BSM">2.6</A>
// set to what?+
        : %AUE_STIME^ subj ret 
        ;



AUE_SWAPON //?
        : %AUE_SWAPON^ 
        ;



AUE_SYMLINK //<A HREF="14753?#APARECORD-13124" TARGET="BSM">2.6</A> **
        : %AUE_SYMLINK^ text path (attr)? subj ret 
        ;



AUE_SYSINFO //<A HREF="14753?#APARECORD-11180" TARGET="BSM">2.6+</A> **
        : %AUE_SYSINFO^ arg[1,"cmd"] ( name:text )? subj ret 
        ;



AUE_SYSTEMBOOT //<A HREF="14753?#APARECORD-33859" TARGET="BSM">2.6+</A> **
        : %AUE_SYSTEMBOOT^ text ( ret )?
        ;



AUE_TRUNCATE //?
        : %AUE_TRUNCATE^ 
        ;



AUE_UMOUNT //<A HREF="14753?#APARECORD-39841" TARGET="BSM">2.6</A>
        : %AUE_UMOUNT^ path (attr)? subj ret 
        ;



AUE_UNLINK //<A HREF="14753?#APARECORD-28864" TARGET="BSM">2.6</A> **
        : %AUE_UNLINK^ path (attr)? subj ret 
        ;



AUE_UNMOUNT //?
        : %AUE_UNMOUNT^ 
        ;



AUE_UTIME //<A HREF="14753?#APARECORD-25388" TARGET="BSM">2.6</A> set to what?+ are times in attr token before or after change ?
        : %AUE_UTIME^ path (attr)? subj ret 
        ;



AUE_UTIMES //<A HREF="14753?#APARECORD-21591" TARGET="BSM">2.6</A> set to what?+ are times in attr token before or after change ?
        : %AUE_UTIMES^ path (attr)? subj ret 
        ;



AUE_UTSSYS //<A HREF="14753?#APARECORD-15824" TARGET="BSM">2.6</A> fusers
        : %AUE_UTSSYS^ path (attr)? subj ret 
        ;



AUE_VFORK //<A HREF="14753?#APARECORD-22522" TARGET="BSM">2.6</A> **
        : %AUE_VFORK^ arg[0,"child PID"] subj ret/*useless*/
        ;



AUE_VPIXSYS //?
        : %AUE_VPIXSYS^ 
        ;



AUE_VTRACE //<A HREF="14753?#APARECORD-15365" TARGET="BSM">2.6</A>
        : %AUE_VTRACE^ subj ret 
        ;



AUE_WRITE //?
        : %AUE_WRITE^ 
        ;



AUE_WRITEL //?
        : %AUE_WRITEL^ 
        ;



AUE_WRITEV //?
        : %AUE_WRITEV^ 
        ;



AUE_WRITEVL //?
        : %AUE_WRITEVL^ 
        ;



AUE_XMKNOD //<A HREF="14753?#APARECORD-33497" TARGET="BSM">2.6</A>
        : %AUE_XMKNOD^ path (attr)? subj ret 
        ;



AUE_XSTAT //<A HREF="14753?#APARECORD-36103" TARGET="BSM">2.6</A>
        : %AUE_XSTAT^ path (attr)? subj ret 
        ;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *              USER-LEVEL GENERATED AUDIT RECORDS BEGIN HERE                *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

AUE_allocate_fail //<A HREF="26186?#APARECORD-14019" TARGET="BSM">2.6</A>
        : %AUE_allocate_fail^ subj newgroups exit 
        ;



AUE_allocate_succ //<A HREF="26186?#APARECORD-24735" TARGET="BSM">2.6</A>
        : %AUE_allocate_succ^ subj newgroups exit 
        ;



AUE_at_create //<A HREF="26186?#APARECORD-18293" TARGET="BSM">2.6+</A> **
        : %AUE_at_create^ subj ( path )? (group)? ret // doc says exit, not ret
        ;



AUE_at_delete //<A HREF="26186?#APARECORD-14512" TARGET="BSM">2.6</A>
        : %AUE_at_delete^ subj (group)? exit 
        ;



AUE_at_perm //<A HREF="26186?#APARECORD-11456" TARGET="BSM">2.6</A>
        : %AUE_at_perm^ subj (group)? exit 
        ;



AUE_create_user //?
        : %AUE_create_user^ 
        ;



AUE_cron_invoke //<A HREF="26186?#APARECORD-35808" TARGET="BSM">2.6+</A> **
// saw this with only one text, it said "new g-queue job for paulf"
// was that "program", "shell", or "cmd"?  I'm guessing program.
// Points out the need to extend this parser to verify, e.g. regular
// expressions for text values.  Note: doc says last is exit, not ret.
        : %AUE_cron_invoke^ subj program:text ( shell:text cmd:text )? ret
        ;



AUE_crontab_create //<A HREF="26186?#APARECORD-12351" TARGET="BSM">2.6</A>
        : %AUE_crontab_create^ subj (group)? exit 
        ;



AUE_crontab_delete //<A HREF="26186?#APARECORD-15517" TARGET="BSM">2.6</A>
        : %AUE_crontab_delete^ subj (group)? exit 
        ;



AUE_crontab_mod //?
        : %AUE_crontab_mod^ subj ( group )? exit 
        ;



AUE_crontab_perm //<A HREF="26186?#APARECORD-11821" TARGET="BSM">2.6</A>
        : %AUE_crontab_perm^ subj (group)? exit 
        ;



AUE_deallocate_fail //<A HREF="26186?#APARECORD-27756" TARGET="BSM">2.6</A>
// event name in BSM guide is typo, right??
        : %AUE_deallocate_fail^ subj newgroups exit 
        ;



AUE_deallocate_succ //<A HREF="26186?#APARECORD-38255" TARGET="BSM">2.6</A>
// event name in BSM guide is typo, right??
        : %AUE_deallocate_succ^ subj newgroups exit 
        ;



AUE_delete_user //?
        : %AUE_delete_user^ 
        ;



AUE_disable_user //?
        : %AUE_disable_user^ 
        ;



AUE_enable_user //?
        : %AUE_enable_user^ 
        ;



AUE_ftpd //<A HREF="26186?#APARECORD-41190" TARGET="BSM">2.6+</A> **
// does "failure only" mean the text token should be optional ?
        : %AUE_ftpd^ subj
	  ( text/*error message, failure only*/ )? ret // so it would seem
        ;



AUE_halt_solaris //<A HREF="26186?#APARECORD-22226" TARGET="BSM">2.6</A>
        : %AUE_halt_solaris^ subj ret 
        ;



AUE_inetd_connect //<A HREF="26186?#APARECORD-31082" TARGET="BSM">2.6</A>
        : %AUE_inetd_connect^ subj text/*service name*/ ret 
        ;



AUE_init_solaris //<A HREF="26186?#APARECORD-31518" TARGET="BSM">2.6</A>
        : %AUE_init_solaris^ subj text/*init level*/ ret 
        ;



AUE_listdevice_fail //<A HREF="26186?#APARECORD-41672" TARGET="BSM">2.6</A>
        : %AUE_listdevice_fail^ subj ( group )? exit 
        ;



AUE_listdevice_succ //<A HREF="26186?#APARECORD-39222" TARGET="BSM">2.6</A>
        : %AUE_listdevice_succ^ subj ( group )? exit 
        ;



AUE_login //<A HREF="26186?#APARECORD-28702" TARGET="BSM">2.6</A> **
        : %AUE_login^ subj text/*error message*/ ret 
        ;



AUE_logout //<A HREF="26186?#APARECORD-14901" TARGET="BSM">2.6+</A> **
        : %AUE_logout^ subj ( text )? ret 
        ;



AUE_modify_user //?
        : %AUE_modify_user^ 
        ;



AUE_mountd_mount //<A HREF="26186?#APARECORD-17735" TARGET="BSM">2.6</A>
// does "failure only" mean that token should be optional ?
        : %AUE_mountd_mount^
	  subj
	  text/*remote client hostname*/
	  path/*mount dir*/
	  text/*error message, failure only*/
	  ret 
        ;



AUE_mountd_umount //<A HREF="26186?#APARECORD-11485" TARGET="BSM">2.6</A>
// does "failure only" mean that token should be optional ?
        : %AUE_mountd_umount^
	  subj
	  text/*remote client hostname*/
	  path/*mount dir*/
	  text/*error message, failure only*/
	  ret 
        ;



AUE_passwd //<A HREF="26186?#APARECORD-39152" TARGET="BSM">2.6</A>
        : %AUE_passwd^ subj text/*error message*/ ret 
        ;



AUE_poweroff_solaris //<A HREF="26186?#APARECORD-37981" TARGET="BSM">2.6</A>
        : %AUE_poweroff_solaris^ subj ret 
        ;



AUE_reboot_solaris //<A HREF="26186?#APARECORD-26341" TARGET="BSM">2.6</A>
        : %AUE_reboot_solaris^ subj ret 
        ;



AUE_rexd //<A HREF="26186?#APARECORD-11184" TARGET="BSM">2.6</A>
        : %AUE_rexd^
	  subj
	  text/*error message, failure only*/
	  text/*hostname*/
	  text/*username*/
	  text/*command to be executed*/
	  exit 
        ;



AUE_rexecd //<A HREF="26186?#APARECORD-25923" TARGET="BSM">2.6</A>
        : %AUE_rexecd^
	  subj
	  text/*error message, failure only*/
	  text/*hostname*/
	  text/*username*/
	  text/*command to be executed*/
	  exit 
        ;



AUE_rlogin //<A HREF="26186?#APARECORD-29307" TARGET="BSM">2.6</A> **
        : %AUE_rlogin^ subj text/*error message*/ ret 
        ;



AUE_rshd //<A HREF="26186?#APARECORD-29743" TARGET="BSM">2.6+</A> **
        : %AUE_rshd^ subj text ( text text )? ret 
        ;



AUE_shutdown_solaris //<A HREF="26186?#APARECORD-26677" TARGET="BSM">2.6</A>
        : %AUE_shutdown_solaris^ subj ret 
        ;



AUE_su //<A HREF="26186?#APARECORD-27155" TARGET="BSM">2.6</A> **
        : %AUE_su^ subj text/*error message*/ ret 
        ;



AUE_telnet //<A HREF="26186?#APARECORD-29202" TARGET="BSM">2.6</A>
        : %AUE_telnet^ subj text/*error message*/ ret 
        ;



AUE_uadmin_solaris //<A HREF="26186?#APARECORD-34783" TARGET="BSM">2.6</A>
        : %AUE_uadmin_solaris^ subj function:text argument:text ret 
        ;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                     AUDIT TOKEN STRUCTURES BEGIN HERE                     *
 * (what BSM calls tokens, i.e., these little groups of several ANTLR tokens)*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

attr //<A HREF="12972?#APARECORD-88901" TARGET="BSM">2.6</A> **
        : %au_attr_tok_t^ 
	  %mode %uid %gid %fs$major %fs$minor %node %dev$major %dev$minor 
        ;



exec_args //<A HREF="12972?#APARECORD-98774" TARGET="BSM">2.6</A> **
      	: %au_exec_args_tok_t^ c:%count
	  ( { int n = (int)((BSMToken.Long)c).value; }
	  : ( { 0 < n-- }? %env_args )* { 0 == n }?
	  )
	;



exec_env //<A HREF="12972?#APARECORD-95750" TARGET="BSM">2.6</A> **
      	: %au_exec_env_tok_t^ c:%count
	  ( { int n = (int)((BSMToken.Long)c).value; }
	  : ( { 0 < n-- }? %env_args )* { 0 == n }?
	  )
	;



exit //<A HREF="12972?#APARECORD-19928" TARGET="BSM">2.6</A>
        : %au_exit_tok_t^ %status %retval 
        ;



group //?
        : %match_nothing 
        ;



groups //<A HREF="12972?#APARECORD-26263" TARGET="BSM">2.6</A>
        : %au_groups_tok_t^ 
        ;



// header <A HREF="12972?#APARECORD-20332" TARGET="BSM">2.6</A> ** is handled
// specially by BSMTokenStream.  It is the only BSM "token" whose fields are
// all returned in a single ANTLR Token (of class BSMToken.Header).  The event
// ID is used to set the 'type' of the ANTLR token, so identifying the event
// is LL(1).



inaddr //<A HREF="12972?#APARECORD-17803" TARGET="BSM">2.6</A>
        : %au_inaddr_tok_t^ %ia 
        ;



ip //<A HREF="12972?#APARECORD-45441" TARGET="BSM">2.6</A>
        : %au_ip_tok_t^ %version //what is this `version'
	                        //and how does it relate to ip_v ?
	  %ip_v %ip_hl %ip_tos %ip_len
	  %ip_id               %ip_off
	  %ip_ttl      %ip_p   %ip_sum
	  %ip_src
	  %ip_dst 
        ;



ipc //<A HREF="12972?#APARECORD-92947" TARGET="BSM">2.6</A>
        : %au_ipc_tok_t^ %id 
        ;



ipc_perm //<A HREF="12972?#APARECORD-33457" TARGET="BSM">2.6</A>
        : %au_ipc_perm_tok_t^ %uid %gid %cuid %cgid %mode %seq %key 
        ;



iport //<A HREF="12972?#APARECORD-89866" TARGET="BSM">2.6</A>
        : %au_iport_tok_t^ %iport 
        ;



newgroups //<A HREF="12972?#APARECORD-900" TARGET="BSM">2.6</A>
        : %au_newgroups_tok_t^ %count ( %groups )* 
        ;



// opaque <A HREF="12972?#APARECORD-39761" TARGET="BSM">2.6</A> not implemented.
// not seen in our sample logs. add here and in BSMTokenStream.c



proc //<A HREF="12972?#APARECORD-77354" TARGET="BSM">2.6</A> **
        : %au_proc_tok_t^ %auid
	  %euid %egid %ruid %rgid
	  %pid %sid
	  %tid$port$major %tid$port$minor %tid$machine 
        ;



ret //<A HREF="12972?#APARECORD-51863" TARGET="BSM">2.6</A> **
        : %au_ret_tok_t^ %error %retval 
        ;



seq //<A HREF="12972?#APARECORD-98374" TARGET="BSM">2.6</A>
        : %au_seq_tok_t^ %num 
        ;



socket //<A HREF="12972?#APARECORD-80324" TARGET="BSM">2.6</A>
// not encountered in our sample logs, token ID AUT_SOCKET appears consistently
// with 4-field (i.e. sockinet) data?!
        : %match_nothing %type %lport %laddr %fport %faddr 
        ;



sockinet //<A HREF="12972?#APARECORD-22507" TARGET="BSM">2.6</A> **
// appears frequently in sample logs, but with token ID of AUT_SOCKET--and
// no au_sock*inet_tok_t struct is defined in system headers?!
        : %au_socket_tok_t^ %type %lport %laddr 
        ;



subj //<A HREF="12972?#APARECORD-21248" TARGET="BSM">2.6</A> **
        : %au_subj_tok_t^ %auid
	  %euid %egid %ruid %rgid
	  %pid %sid
	  %tid$port$major %tid$port$minor %tid$machine 
        ;



server //?
        : %au_server_tok_t^ %auid %euid %ruid %egid %pid 
        ;



data //<A HREF="12972?#APARECORD-20099" TARGET="BSM">2.6</A>
        : %au_data_tok_t^ %pfmt %size %number %data 
        ;



file //<A HREF="12972?#APARECORD-71226" TARGET="BSM">2.6</A> **
        : %au_file_tok_t^ %time %msec %length! %fname 
        ;



text //<A HREF="12972?#APARECORD-68505" TARGET="BSM">2.6</A> **
        : %au_text_tok_t^ %length! %data 
        ;



// trailer <A HREF="12972?#APARECORD-10489" TARGET="BSM">2.6</A> not implemented
// not encountered in our sample logs. add here and in BSMTokenStream.c



path //<A HREF="12972?#APARECORD-19429" TARGET="BSM">2.6</A> **
        : %au_path_tok_t^ %length! %name 
        ;



arg //<A HREF="12972?#APARECORD-84939" TARGET="BSM">2.6</A> **
[int argnum, java.lang.String desc]
        : { isArg( argnum, desc) }? %au_arg_tok_t^ %num %val %length! %data 
        ;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *               Event IS A VERY LONG AND UNINTERESTING RULE                 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


Event 
        : AUE_ACCEPT 
        | AUE_ACCESS 
        | AUE_ACCT 
        | AUE_ACLSET 
        | AUE_ADJTIME 
        | AUE_ASYNC_DAEMON 
        | AUE_ASYNC_DAEMON_EXIT 
        | AUE_AUDIT 
        | AUE_AUDITON 
        | AUE_AUDITON_GESTATE 
        | AUE_AUDITON_GETCAR 
        | AUE_AUDITON_GETCLASS 
        | AUE_AUDITON_GETCOND 
        | AUE_AUDITON_GETCWD 
        | AUE_AUDITON_GETKMASK 
        | AUE_AUDITON_GETSTAT 
        | AUE_AUDITON_GPOLICY 
        | AUE_AUDITON_GQCTRL 
        | AUE_AUDITON_GTERMID 
        | AUE_AUDITON_SESTATE 
        | AUE_AUDITON_SETCLASS 
        | AUE_AUDITON_SETCOND 
        | AUE_AUDITON_SETKMASK 
        | AUE_AUDITON_SETSMASK 
        | AUE_AUDITON_SETSTAT 
        | AUE_AUDITON_SETUMASK 
        | AUE_AUDITON_SPOLICY 
        | AUE_AUDITON_SQCTRL 
        | AUE_AUDITON_STERMID 
        | AUE_AUDITSTAT 
        | AUE_AUDITSVC 
        | AUE_AUDITSYS 
        | AUE_BIND 
        | AUE_BSMSYS 
        | AUE_CHDIR 
        | AUE_CHMOD 
        | AUE_CHOWN 
        | AUE_CHROOT 
        | AUE_CLOSE 
        | AUE_CONNECT 
        | AUE_CORE 
        | AUE_CREAT 
        | AUE_DOORFS 
        | AUE_DOORFS_DOOR_BIND 
        | AUE_DOORFS_DOOR_CALL 
        | AUE_DOORFS_DOOR_CREATE 
        | AUE_DOORFS_DOOR_CRED 
        | AUE_DOORFS_DOOR_INFO 
        | AUE_DOORFS_DOOR_RETURN 
        | AUE_DOORFS_DOOR_REVOKE 
        | AUE_DOORFS_DOOR_UNBIND 
        | AUE_DUP2 
        | AUE_ENTERPROM 
        | AUE_EXEC 
        | AUE_EXECVE 
        | AUE_EXIT 
        | AUE_EXITPROM 
        | AUE_EXPORTFS 
        | AUE_FACLSET 
        | AUE_FCHDIR 
        | AUE_FCHMOD 
        | AUE_FCHOWN 
        | AUE_FCHROOT 
        | AUE_FCNTL 
        | AUE_FLOCK 
        | AUE_FORK 
        | AUE_FORK1 
        | AUE_FSTAT 
        | AUE_FSTATFS 
        | AUE_FTRUNCATE 
        | AUE_GETAUDIT 
        | AUE_GETAUID 
        | AUE_GETDENTS 
        | AUE_GETKERNSTATE 
        | AUE_GETMSG 
        | AUE_GETPMSG 
        | AUE_GETPORTAUDIT 
        | AUE_GETUSERAUDIT 
        | AUE_INST_SYNC 
        | AUE_IOCTL 
        | AUE_JUNK 
        | AUE_KILL 
        | AUE_KILLPG 
        | AUE_LCHOWN 
        | AUE_LINK 
        | AUE_LSEEK 
        | AUE_LSTAT 
        | AUE_LXSTAT 
        | AUE_MCTL 
        | AUE_MEMCNTL 
        | AUE_MKDIR 
        | AUE_MKNOD 
        | AUE_MMAP 
        | AUE_MODADDMAJ 
        | AUE_MODCONFIG 
        | AUE_MODCTL 
        | AUE_MODLOAD 
        | AUE_MODUNLOAD 
        | AUE_MOUNT 
        | AUE_MSGCTL 
        | AUE_MSGCTL_RMID 
        | AUE_MSGCTL_SET 
        | AUE_MSGCTL_STAT 
        | AUE_MSGGET 
        | AUE_MSGGETL 
        | AUE_MSGRCV 
        | AUE_MSGRCVL 
        | AUE_MSGSND 
        | AUE_MSGSNDL 
        | AUE_MSGSYS 
        | AUE_MUNMAP 
        | AUE_NFS 
        | AUE_NFSSVC_EXIT 
        | AUE_NFS_GETFH 
        | AUE_NFS_SVC 
        | AUE_NICE 
        | AUE_NULL 
        | AUE_ONESIDE 
        | AUE_OPEN 
        | AUE_OPEN_R 
        | AUE_OPEN_RC 
        | AUE_OPEN_RT 
        | AUE_OPEN_RTC 
        | AUE_OPEN_RW 
        | AUE_OPEN_RWC 
        | AUE_OPEN_RWT 
        | AUE_OPEN_RWTC 
        | AUE_OPEN_W 
        | AUE_OPEN_WC 
        | AUE_OPEN_WT 
        | AUE_OPEN_WTC 
        | AUE_OSETPGRP 
        | AUE_OSETUID 
        | AUE_OSTAT 
        | AUE_PATHCONF 
        | AUE_PIPE 
        | AUE_PRIOCNTLSYS 
        | AUE_PROCESSOR_BIND 
        | AUE_PUTMSG 
        | AUE_PUTPMSG 
        | AUE_P_ONLINE 
        | AUE_QUOTACTL 
        | AUE_READ 
        | AUE_READL 
        | AUE_READLINK 
        | AUE_READV 
        | AUE_READVL 
        | AUE_REBOOT 
        | AUE_RECV 
        | AUE_RECVFROM 
        | AUE_RECVMSG 
        | AUE_RENAME 
        | AUE_RFSSYS 
        | AUE_RMDIR 
        | AUE_SEMCTL 
        | AUE_SEMCTL_GETALL 
        | AUE_SEMCTL_GETNCNT 
        | AUE_SEMCTL_GETPID 
        | AUE_SEMCTL_GETVAL 
        | AUE_SEMCTL_GETZCNT 
        | AUE_SEMCTL_RMID 
        | AUE_SEMCTL_SET 
        | AUE_SEMCTL_SETALL 
        | AUE_SEMCTL_SETVAL 
        | AUE_SEMCTL_STAT 
        | AUE_SEMGET 
        | AUE_SEMGETL 
        | AUE_SEMOP 
        | AUE_SEMSYS 
        | AUE_SEND 
        | AUE_SENDMSG 
        | AUE_SENDTO 
        | AUE_SETAUDIT 
        | AUE_SETAUID 
        | AUE_SETDOMAINNAME 
        | AUE_SETEGID 
        | AUE_SETEUID 
        | AUE_SETGID 
        | AUE_SETGROUPS 
        | AUE_SETHOSTNAME 
        | AUE_SETKERNSTATE 
        | AUE_SETPGRP 
        | AUE_SETPRIORITY 
        | AUE_SETREGID 
        | AUE_SETREUID 
        | AUE_SETRLIMIT 
        | AUE_SETSOCKOPT 
        | AUE_SETTIMEOFDAY 
        | AUE_SETUSERAUDIT 
        | AUE_SHMAT 
        | AUE_SHMCTL 
        | AUE_SHMCTL_RMID 
        | AUE_SHMCTL_SET 
        | AUE_SHMCTL_STAT 
        | AUE_SHMDT 
        | AUE_SHMGET 
        | AUE_SHMGETL 
        | AUE_SHMSYS 
        | AUE_SHUTDOWN 
        | AUE_SOCKACCEPT 
        | AUE_SOCKCONNECT 
        | AUE_SOCKET 
        | AUE_SOCKETPAIR 
        | AUE_SOCKRECEIVE 
        | AUE_SOCKSEND 
        | AUE_STAT 
        | AUE_STATFS 
        | AUE_STATVFS 
        | AUE_STIME 
        | AUE_SWAPON 
        | AUE_SYMLINK 
        | AUE_SYSINFO 
        | AUE_SYSTEMBOOT 
        | AUE_TRUNCATE 
        | AUE_UMOUNT 
        | AUE_UNLINK 
        | AUE_UNMOUNT 
        | AUE_UTIME 
        | AUE_UTIMES 
        | AUE_UTSSYS 
        | AUE_VFORK 
        | AUE_VPIXSYS 
        | AUE_VTRACE 
        | AUE_WRITE 
        | AUE_WRITEL 
        | AUE_WRITEV 
        | AUE_WRITEVL 
        | AUE_XMKNOD 
        | AUE_XSTAT 
        | AUE_allocate_fail 
        | AUE_allocate_succ 
        | AUE_at_create 
        | AUE_at_delete 
        | AUE_at_perm 
        | AUE_create_user 
        | AUE_cron_invoke 
        | AUE_crontab_create 
        | AUE_crontab_delete 
        | AUE_crontab_mod 
        | AUE_crontab_perm 
        | AUE_deallocate_fail 
        | AUE_deallocate_succ 
        | AUE_delete_user 
        | AUE_disable_user 
        | AUE_enable_user 
        | AUE_ftpd 
        | AUE_halt_solaris 
        | AUE_inetd_connect 
        | AUE_init_solaris 
        | AUE_listdevice_fail 
        | AUE_listdevice_succ 
        | AUE_login 
        | AUE_logout 
        | AUE_modify_user 
        | AUE_mountd_mount 
        | AUE_mountd_umount 
        | AUE_passwd 
        | AUE_poweroff_solaris 
        | AUE_reboot_solaris 
        | AUE_rexd 
        | AUE_rexecd 
        | AUE_rlogin 
        | AUE_rshd 
        | AUE_shutdown_solaris 
        | AUE_su 
        | AUE_telnet 
        | AUE_uadmin_solaris 
        ;
