#include <windows.h>
#include <windowsx.h>
#include "tasktest.h"
#include "mmtask.h"

#ifdef __WATCOMC__
    #pragma off (unreferenced);
#endif

#define READ_SIZE        4096
int     _nTaskCount = 0;
char   *_InFileName = "test.bmp";
HWND    Edit;

TASKPROC CallThunk;
void CALLBACK __export TaskCallback(WORD wA, WORD wB);
void EditDebugOut(const char *szFmt, ...);

BOOL Command(HWND Dialog, UINT Message, WPARAM Param1, LPARAM Param2)
    {
    static int nP = 1;

    if(Param1 == IDM_CREATE)
        {
        WORD    hTask;
        MMTaskCreate(CallThunk, &hTask, nP++, 0);
        }
    else if(Param1 == IDM_CREATE_2)
        CallThunk(0, nP++);
    else if(Param1 == IDM_READ)
        {
        HFILE hRead;
        LPSTR lpBuffer;

        EditDebugOut("Start Read");
        if ((hRead = _lopen(_InFileName, READ))
                                           == HFILE_ERROR) {
            EditDebugOut("Couldn't open file %s",
                            (LPSTR)_InFileName);
            return FALSE;
        }
        if ((lpBuffer = GlobalAllocPtr(GMEM_MOVEABLE,
                                      READ_SIZE)) == NULL) {
            _lclose(hRead);
            return TRUE;
        }
        while (_lread(hRead, lpBuffer, READ_SIZE) > 0)
            ;
        GlobalFreePtr(lpBuffer);
        _lclose(hRead);
        EditDebugOut("End Read");
        }
    return TRUE;
    }

BOOL CALLBACK DialogProc(HWND Dialog, UINT Message,
                               WPARAM Param1, LPARAM Param2)
    {
    if(Message == WM_INITDIALOG)
        Edit    = GetDlgItem(Dialog, ID_EDIT);
    else if(Message == WM_COMMAND)
        {
        if(Param1 == IDOK || Param1 == IDCANCEL)
            EndDialog(Dialog, TRUE);
        else
            return Command(Dialog, Message, Param1, Param2);
        }
    return 0;
    }

#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain(HINSTANCE This, HINSTANCE Previous,
        LPSTR CommandLine, int Show)
    {
    CallThunk   = (TASKPROC)MakeProcInstance(
                               (FARPROC)TaskCallback, This);
    DialogBox(This, "TASKTEST", (HWND)NULL, DialogProc);
    FreeProcInstance((FARPROC)CallThunk);
    return 1;
    }


void EditDebugOut(const char *szFmt, ...)
{
    static long _lStart = 0L;
    long lTime;
    int nLen, nSec, nMilli;
    char szBuffer[256];
    LPSTR pArguments;

    if (_lStart == 0L)
        _lStart = GetTickCount();

    lTime = GetTickCount() - _lStart;
    nSec = (int)(lTime / 1000L);
    nMilli = (int)(lTime - ((long)nSec * 1000L));
    nLen = wsprintf(szBuffer, "t TaskTest  %d.%03d: ",
                                              nSec, nMilli);
    pArguments = (char *)&szFmt + sizeof szFmt;
    wvsprintf(szBuffer + nLen, szFmt, pArguments);
    lstrcat(szBuffer, "\r\n");

    //Edit_GetTextLength fails sometimes/use WM_GETTEXTLENGTH
    nLen = (int)SendMessage(Edit, WM_GETTEXTLENGTH, 0, 0L);
    // set selection to end, then replace to append
    Edit_SetSel(Edit, nLen, nLen);
    Edit_ReplaceSel(Edit, szBuffer);
}

void CALLBACK __export TaskCallback(WORD wParamA,
                                               WORD wParamB)
{
    MSG msg;
    HFILE hRead;
    DWORD dwNew, dwTick, dwCount = 0L;
    LPSTR lpBuffer;
    BOOL bStop = FALSE;

    _nTaskCount++;
    EditDebugOut("Start %s Task %d", wParamA ? "background"
                   : "direct", wParamA ? wParamA : wParamB);
    // Beware: we're on a different PSP here
    if ((hRead=_lopen(_InFileName, READ)) == HFILE_ERROR) {
        EditDebugOut("Couldn't open file %s", _InFileName);
        _nTaskCount--;
        return;
    }
    // Don't use malloc() here! The subsegment allocation
    //  mechanism gets confused.
    if ((lpBuffer = GlobalAllocPtr(GMEM_MOVEABLE, READ_SIZE))
                                                   == NULL) {
        _lclose(hRead);
        _nTaskCount--;
        return;
    }
    dwTick = GetTickCount();
    while (bStop == FALSE) {
        if (PeekMessage(&msg, (HWND)NULL, 0, 0, PM_REMOVE))
            // won't be any messages if called by mmtask.tsk
            DispatchMessage(&msg);
        if (((dwNew = GetTickCount()) - dwTick) > 50) {
            // Read part of the file. 4K per 50 ms = 80 Kb/s
            dwTick = dwNew;
            dwCount++;
            if (_lread(hRead, lpBuffer, READ_SIZE) != READ_SIZE) {
                bStop = TRUE;
            }
        }
    }
    GlobalFreePtr(lpBuffer);
    _lclose(hRead);
    EditDebugOut("End Task %d. No of reads: %ld",
            wParamA ? wParamA : wParamB, dwCount);
    _nTaskCount--;
    return;
}

