#include <windows.h>
#include <string.h>

#include "asyncwav.rh"

// these come from asyncwav.c 
extern HWND AsyncWave( HWND hwndParent, HGLOBAL hWave );
extern UINT wm_asyncwavedone;

// app's HINSTANCE
HINSTANCE hInst;

#define LoadWave( hInst, lpszName ) LoadResource(hInst, \
               (FindResource(hInst,lpszName,"WAVE")))

void CMTest( HWND hwnd )
{
   EnableMenuItem(GetMenu(hwnd),CM_TEST,MF_GRAYED);
   AsyncWave(hwnd,LoadWave(hInst,"DING"));
}

LRESULT CALLBACK _export MainWndProc( HWND hwnd, UINT msg,
   WPARAM wParam, LPARAM lParam )
{
   switch(msg) {
      case WM_COMMAND:
         switch(wParam) {
            case CM_EXIT:
               SendMessage(hwnd,WM_CLOSE,0,0);
               return 0;
            case CM_TEST:
               CMTest(hwnd);
               return 0;
         }
         break;
      case WM_DESTROY:
         PostQuitMessage(0);
         return 0;
      default:
         if( msg && msg == wm_asyncwavedone ) {
            EnableMenuItem(GetMenu(hwnd),CM_TEST,MF_ENABLED);
            DrawMenuBar(hwnd);
            return 0;
         }
         break;
   }
   return DefWindowProc(hwnd,msg,wParam,lParam);
}

int MessagePump(void)
{
   MSG msg;
   while( GetMessage(&msg,NULL,0,0) ) {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }
   return msg.wParam;
}

#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain(HINSTANCE hInstance,HINSTANCE hPrevInst,
                    LPSTR lpstrCmdLine, int nCmdShow )
{
   char szClassName[] = "Async Wave Test";
   HWND hwnd;
   hInst = hInstance;
   if(!hPrevInst) {
      WNDCLASS wc;
      memset(&wc,0,sizeof(wc));
      wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
      wc.hCursor       = LoadCursor(NULL,IDC_ARROW);
      wc.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
      wc.lpfnWndProc   = MainWndProc;
      wc.lpszClassName = szClassName;
      wc.hInstance     = hInst;
      wc.lpszMenuName  = "MENU";
      RegisterClass(&wc);
   }
   hwnd = CreateWindow(szClassName,szClassName,
                       WS_OVERLAPPEDWINDOW,
                       CW_USEDEFAULT,CW_USEDEFAULT,250,250,
                       NULL,NULL,hInst,NULL);
   if(hwnd) {
      ShowWindow(hwnd,nCmdShow);
      UpdateWindow(hwnd);
      return MessagePump();
   }
   return -1;
}

