#include <windows.h>
#include <windowsx.h>
#include <mmsystem.h>
#include <string.h>

#define LOCALFUNC static __near __pascal

extern HINSTANCE hInst;  // hInstance for this module
UINT wm_asyncwavedone;   // notification message id

#define GetOwner(hwnd) GetWindow(hwnd,GW_OWNER)

// RIFF chunk structure
typedef struct tagCHUNK {
   FOURCC ckId;     // four character ID
   DWORD  ckSize;     // size of chunk
   BYTE   ckData[1];  // this can be variable size
} CHUNK, FAR *LPCHUNK;

// async wave window data structure
typedef struct tagAWWDATA {
   HGLOBAL   hWave;     // global handle to WAVE file
   LPSTR     lpWave;    // pointer to wave data
   HWAVEOUT  hWaveOut;  // handle for WAVE device
   HGLOBAL   hWaveHdr;  // global handle of wave header memory block
   LPWAVEHDR lpWaveHdr; // pointer to wave header memory block
   BOOL      bDone;     // done flag
} AWWDATA, FAR *LPAWWDATA;

LPCHUNK LOCALFUNC GetWaveChunk( LPSTR lpDat, FOURCC ckId )
// given a pointer to a memory WAVE, return the chunk
// identified by ckId
{
   LPCHUNK lpC = (LPCHUNK)lpDat;
   LONG dwSize;
   if( !lpC ) return NULL;
   // check for RIFF chunk
   if( lpC->ckId != mmioFOURCC('R','I','F','F') )
      return NULL;
   // data should start with "WAVE"
   if( _fstrncmp((LPSTR)lpC->ckData,"WAVE",4) )
      return NULL;
   dwSize = lpC->ckSize;  // save size of RIFF chunk
   lpC = (LPCHUNK)(lpC->ckData+4);
   while( lpC->ckId != ckId ) {
      lpC = (LPCHUNK)(lpC->ckData + (WORD)lpC->ckSize);
      if( (LPSTR)lpC-lpDat > dwSize )
         return NULL;
   }
   return lpC;  // return pointer to chunk
}

LPWAVEFORMAT LOCALFUNC GetWaveFmt( LPSTR lpDat )
// return a pointer to the WAVEFORMAT struct in a WAVE
// memory block
{
   LPCHUNK lpC;
   lpC = GetWaveChunk(lpDat,mmioFOURCC('f','m','t',' '));
   if(lpC)
      return (LPWAVEFORMAT)lpC->ckData;
   else
      return NULL;
}

DWORD LOCALFUNC GetWaveDataSize( LPSTR lpDat )
// return the size of the data chunk in WAVE memory block
{
   LPCHUNK lpC;
   lpC = GetWaveChunk(lpDat,mmioFOURCC('d','a','t','a'));
   if(lpC)
      return lpC->ckSize;
   else
      return 0;
}

LPSTR LOCALFUNC GetWaveData( LPSTR lpDat )
// get a pointer to raw WAVE data
{
   LPCHUNK lpC;
   lpC = GetWaveChunk(lpDat,mmioFOURCC('d','a','t','a'));
   if(lpC)
      return (LPSTR)lpC->ckData;
   else
      return 0;
}

WORD LOCALFUNC OpenDevice( HWND hwnd )
// open the wave device
{
   LPAWWDATA lpAWWD = (LPAWWDATA)GetWindowLong(hwnd,0);
   LPWAVEFORMAT lpWaveFmt = GetWaveFmt(lpAWWD->lpWave);
   WORD r = waveOutOpen(
&lpAWWD->hWaveOut,
(UINT)WAVE_MAPPER,
      lpWaveFmt,
MAKELPARAM(hwnd,0),0,CALLBACK_WINDOW);
   if( r && GetOwner(hwnd) )
      SendMessage(GetOwner(hwnd),wm_asyncwavedone,r,0);
   return r;
}

void LOCALFUNC StartWave( HWND hwnd )
// start the wave
{
   WORD r;
   LPAWWDATA lpAWWD = (LPAWWDATA)GetWindowLong(hwnd,0);
   lpAWWD->hWaveHdr =
      GlobalAlloc(GMEM_MOVEABLE|GMEM_SHARE|GMEM_ZEROINIT,
      sizeof(WAVEHDR));
   lpAWWD->lpWaveHdr =
      (LPWAVEHDR)GlobalLock(lpAWWD->hWaveHdr);
   if( !lpAWWD->hWaveHdr ) {
      if( GetOwner(hwnd) )
         SendMessage(GetOwner(hwnd),wm_asyncwavedone,
            MMSYSERR_NOMEM,0);
      DestroyWindow(hwnd);
      return;
   }
   lpAWWD->lpWaveHdr->lpData = GetWaveData(lpAWWD->lpWave);
   lpAWWD->lpWaveHdr->dwBufferLength =
      GetWaveDataSize(lpAWWD->lpWave);
   r = waveOutPrepareHeader(lpAWWD->hWaveOut,
      lpAWWD->lpWaveHdr,sizeof(WAVEHDR));
   if( !r )
      r = waveOutWrite(lpAWWD->hWaveOut,lpAWWD->lpWaveHdr,
         sizeof(WAVEHDR));
   if( r ) {
      if( GetOwner(hwnd) )
         SendMessage(GetOwner(hwnd),wm_asyncwavedone,r,0);
      DestroyWindow(hwnd);
      return;
   }
}

LRESULT LOCALFUNC WMCreate( HWND hwnd, HGLOBAL hWave )
{
   if( !hWave ) {
      if( GetOwner(hwnd) )
         SendMessage(GetOwner(hwnd),wm_asyncwavedone,
            MMSYSERR_INVALPARAM,0);
      return -1; // no data, no window
   } else {
      // allocate for window data
      LPAWWDATA lpAWWD = GlobalAllocPtr(GPTR,sizeof(AWWDATA));
      if( lpAWWD == NULL )
         return -1;
      SetWindowLong(hwnd,0,(LPARAM)lpAWWD);
      // save wave handle and pointer
      lpAWWD->hWave = hWave;
      lpAWWD->lpWave = LockResource(hWave);
      if( OpenDevice(hwnd) )
         return -1;
      else
         return 0;
   }
}

void LOCALFUNC WOMDone( HWND hwnd )
{
   LPAWWDATA lpAWWD = (LPAWWDATA)GetWindowLong(hwnd,0);
   if( !lpAWWD->bDone ) {
      lpAWWD->bDone = TRUE;  // set the done flag
      if( GetOwner(hwnd) )
         SendMessage(GetOwner(hwnd),wm_asyncwavedone,0,0);
      DestroyWindow(hwnd);
   }
}

LRESULT LOCALFUNC WMDestroy( HWND hwnd )
{

   LPAWWDATA lpAWWD = (LPAWWDATA)GetWindowLong(hwnd,0);
   if(lpAWWD) {
      if(lpAWWD->hWaveOut) {
         if( !lpAWWD->bDone ) {
            lpAWWD->bDone = TRUE;
            waveOutReset(lpAWWD->hWaveOut);// stop playing
         }
         if(lpAWWD->lpWaveHdr)
            waveOutUnprepareHeader(lpAWWD->hWaveOut,
               lpAWWD->lpWaveHdr,sizeof(WAVEHDR));
         waveOutClose(lpAWWD->hWaveOut); //close the device
      }
      if( lpAWWD->hWaveHdr ) {
         GlobalUnlock(lpAWWD->hWaveHdr);
         GlobalFree(lpAWWD->hWaveHdr);
      }
      if( lpAWWD->hWave ) {
         UnlockResource(lpAWWD->hWave);
         FreeResource(lpAWWD->hWave);
      }
      GlobalFreePtr(lpAWWD);
   }
   return 0;
}

LRESULT CALLBACK _export AsyncWaveWndProc(
   HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
   switch(msg) {
      case WM_CREATE:
         return WMCreate(hwnd,
            (HGLOBAL)(LPARAM)
            (((LPCREATESTRUCT)lParam)->lpCreateParams));

      case MM_WOM_OPEN:
         StartWave(hwnd);
         return 0;

      case MM_WOM_DONE:
         WOMDone(hwnd);
         return 0;

      case WM_DESTROY:
         return WMDestroy(hwnd);
   }
   return DefWindowProc(hwnd,msg,wParam,lParam);
}

static char szClassName[] = "AsyncWaveWndClass";

HWND AsyncWave( HWND hwndParent, HGLOBAL hWave )
{
   WNDCLASS wc;
   // if this class is not registered, register it.
   if( !GetClassInfo(hInst,szClassName,&wc) ) {
      memset(&wc,0,sizeof(wc));
      wc.lpfnWndProc   = AsyncWaveWndProc;
      wc.hInstance     = hInst;
      wc.hCursor       = LoadCursor(NULL,IDC_ARROW);
      wc.hbrBackground = NULL;
      wc.lpszClassName = szClassName;
      wc.cbWndExtra    = sizeof(LPAWWDATA);
      RegisterClass(&wc);
   }
   if( !wm_asyncwavedone )
      wm_asyncwavedone =
         RegisterWindowMessage("wm_asyncwavedone");
   return CreateWindow(szClassName,"Async Wave Window",
      WS_OVERLAPPED,0,0,0,0,hwndParent,NULL,hInst,
      (LPSTR)(LPARAM)(void FAR *)hWave);
}


