/***********************************************************
*   Common Dialog Box example with hook to show            *
*   selected file size. Public Domain by Mark Gamber       *
***********************************************************/
#include "windows.h"
#include "commdlg.h"
#include "string.h"

#ifdef __WATCOMC__
    #pragma off (unreferenced);
#endif

BOOL WINAPI __export MainDlgProc( HWND, UINT, WPARAM, LPARAM );
UINT CALLBACK __export FileOpenHook( HWND, UINT, WPARAM, LPARAM );
BOOL DoOpenFile( HWND hDlg );

HINSTANCE hInst;

#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrev,
                                    LPSTR lpCmd, int nShow )
{

   hInst = hInstance;     //  Just start our dialog box
   DialogBox( hInstance, "HOOK", NULL, MainDlgProc );
   return( FALSE );
}

#ifdef __BORLANDC__
    #pragma argsused
#endif
BOOL WINAPI __export MainDlgProc( HWND hDlg, UINT msg,
                              WPARAM wParam, LPARAM lParam )
{
   switch( msg )
   {
      case WM_INITDIALOG:
         return( TRUE );
      case WM_COMMAND:
         //  Quit on Exit
         if( wParam == 101 || wParam == IDCANCEL )
         {
            EndDialog( hDlg, TRUE );
            return( TRUE );
         }
         if( wParam == 100 )  //  Or do a File Open box
         {
            DoOpenFile( hDlg );
            break;
         }
         break;
   }
   return( FALSE );         //  Simple enough, huh?
}

// === Handles Common Dialog Function ======================
BOOL DoOpenFile( HWND hDlg )
{
   OPENFILENAME of;
   char Filename[ 256 ];

   _fmemset( (LPVOID)&of, 0, sizeof(OPENFILENAME) );
   lstrcpy( Filename, "*.*" );

   of.lStructSize = sizeof(OPENFILENAME);
   of.hwndOwner = hDlg;
   of.lpstrFilter = "All Files\0*.*\0\0";
   of.lpstrFile = Filename;
   of.nMaxFile = 256;
   of.lpstrTitle = "OpenFile Hook";
   //  Specify hook enabled
   of.Flags     = OFN_FILEMUSTEXIST | OFN_ENABLEHOOK;
   of.lpfnHook  = FileOpenHook;    //  and provide a function

   return( GetOpenFileName( &of ) );
}

// === OpenFileName Hook Proc (note the _export for Win16) 
UINT CALLBACK __export FileOpenHook( HWND hDlg, UINT msg,
                              WPARAM wParam, LPARAM lParam )
{
   if( msg == WM_INITDIALOG )  //  When the dialog starts...
   {
      RECT Rect;
      HANDLE hMem;
      LPSTR lpStr;
      
      //  Enlarge the client area slightly
      GetWindowRect( hDlg, &Rect );
      Rect.bottom += 4;
      SetWindowPos( hDlg, NULL, 0, 0, Rect.right - Rect.left,
         Rect.bottom - Rect.top, SWP_NOZORDER | SWP_NOMOVE );
      
      hMem = GlobalAlloc( GHND, 1024 );//Allocate small block
      if( hMem )                //  to hold the description
      {                         //  string for dialog repaints
         lpStr = GlobalLock( hMem );
         *lpStr = '\0';         //  Initialize to no string
         GlobalUnlock( hMem );
         //  Save as dialog property
         SetProp( hDlg, "CDLGHOOK", hMem );
      }
      return( FALSE );
   }

   if(msg == WM_COMMAND) // Something happened in dialog box
   {
      //  If dialog is about to close
      if( wParam == IDOK || wParam == IDCANCEL )
      {     // then release memory and remove property
         if( GetProp( hDlg, "CDLGHOOK" ) )
         {
            GlobalFree( GetProp( hDlg, "CDLGHOOK" ) );
            RemoveProp( hDlg, "CDLGHOOK" );
         }
      }
      
      if( wParam == 0x0460 && HIWORD( lParam ) == LBN_SELCHANGE )
      { // If file listbox item changed...
         char str[ 256 ]; 
         UINT index;
         LONG lSize;
         HANDLE hMem;
         HFILE  hFile;
         OFSTRUCT Ofn;
         TEXTMETRIC Tm;
         HDC hDC;
         int Ypos;
         RECT Rect;
         HFONT hFont;
         WORD wDate, wTime;
         LPSTR lpStr;
         
         //  Get the item selected
         index = (UINT)SendMessage( (HWND)lParam,
                                      LB_GETCURSEL, 0, 0L );
         if( index == (UINT)LB_ERR )
            return( FALSE );
         //  Get the filename based on the item
         SendMessage( (HWND)lParam, LB_GETTEXT, index,
                                         (LONG)(LPSTR)str );
         if( ! lstrlen( str ) )
            return( FALSE );
         //  Open the file (or die trying)
         hFile = OpenFile( str, &Ofn, OF_READ );
         if( hFile == HFILE_ERROR )
            return( FALSE );

         lSize = _llseek( hFile, 0, 2 );    // Seek-to-end to get the size
         
/**********************************************************
 *   WARNING WARNING WARNING WARNING WARNING ING WARNING  *
 *                                                        *
 *   You are about to see inline assembler to get file's  *
 *   time/date last accessed. Must replace this in Windows*
 *   NT with GetFileTime() and conversion functions.      *
 *   Code puts file handle in BX and calls INT 21H to get *
 *   file's "last changed" time/date, storing them in 2   *
 *   word-sized variables for later dissection. Remember, *
 *   don't try porting this!                              *
 **********************************************************/

         _asm {
            mov ax, 0x5700
            mov bx, hFile
            int 0x21
            mov wDate ,dx
            mov wTime, cx
         }

         _lclose( hFile ); // end of the file, then close it.

    //  Make a printable string from various bits and bytes
    //  Look up INT 21h, Function 57h for details

         wsprintf( str, "%lu bytes Last changed: "
                           "%.2d-%.2d-%.2d, %d:%.2d", lSize,
                     ( wDate & 0x01E0 ) >> 5, wDate & 0x01F,
                         ( ( wDate & 0xFE00 ) >> 9 ) + 1980,
                                   ( wTime & 0xF800 ) >> 11,
                                  ( wTime & 0x07E0 ) >> 5 );
         //  Overwrite any junk
         lstrcat( str, "                    " );
         GetClientRect( hDlg, &Rect );

         //  Make a printable string and a place to put it
         hDC = GetDC( hDlg );

         hFont = (HFONT)SendMessage( hDlg, WM_GETFONT, 0, 0L );
         if( hFont )
            //  Select dialog's default font
            SelectObject( hDC, hFont );
         //  Figure out where to print the string
         GetTextMetrics( hDC, &Tm );
         Ypos = Rect.bottom - Tm.tmHeight - 2;
         //  Blast out the string and exit
         SetTextColor( hDC, RGB( 0, 0, 0 ) );
         TextOut( hDC, 8, Ypos, str, lstrlen( str ) );
         ReleaseDC( hDlg, hDC );
         
         hMem = GetProp( hDlg, "CDLGHOOK" );
         if( hMem )
         {
            lpStr = GlobalLock( hMem );
            lstrcpy( lpStr, str );
            GlobalUnlock( hMem );
         }
         return( FALSE );
      }
      return( FALSE );
   }
   
   if( msg == WM_PAINT ) // Redisplay current file description
   {
      HANDLE hMem;
      LPSTR lpStr;
      HDC hDC;
      RECT Rect;
      TEXTMETRIC Tm;
      int Ypos;
      HFONT hFont;
      
      hMem = GetProp( hDlg, "CDLGHOOK" ); // Get memory block
      if( hMem )
      {
         lpStr = GlobalLock( hMem );                        
         if( lpStr )
         {
            if( *lpStr )  // If there is anything to display
            {
               GetClientRect( hDlg, &Rect );
               // Get a DC and use default font
               hDC = GetDC( hDlg );

               hFont = (HFONT)SendMessage( hDlg, WM_GETFONT, 0, 0L );
               if( hFont )
                  SelectObject( hDC, hFont );
               //  Get font height and use it
               GetTextMetrics( hDC, &Tm );
               //  to find positioning
               Ypos = Rect.bottom - Tm.tmHeight - 2;

               SetTextColor( hDC, RGB( 0, 0, 0 ) );
               TextOut( hDC, 8, Ypos, lpStr, lstrlen( lpStr ) );
               ReleaseDC( hDlg, hDC );
            }
            GlobalUnlock( hMem );  //  Clean up on exit
         }
      }
   }
   return( FALSE );
}

