//
// BUG011.CPP
//
// This program illustrates a bug in Visual C++ 2.0.
// Class foo has two constructors, one that takes
// an integer argument, and one that takes a string
// argument.  Both constructors have a second argument,
// which has a default value.
//
// As this program illustrates, the compiler generates
// bad code when it has to pass the default argument
// for integer constructor.  Instead of passing the
// string "integer", it passes "string".  If you examine
// the assembly output, you will see that it understands
// that the two default arguments are different, it just
// inadvertenly defines one of them incorrectly:
//
//  _DATA   SEGMENT
//  $SG522  DB  'string', 00H, 00H
//  $SG524  DB  'string', 00H  ;Here is the problem!
//
// ; 21   :     foo a( -1 );
//
//   push  OFFSET FLAT:$SG522
//   push  -1
//   lea   ecx, DWORD PTR _a$[ebp]
//   call  ??0foog@@QAE@HPBD@Z; foo::foo
//
// ; 22   :     foo b( "-1" );
//
//   push  OFFSET FLAT:$SG524
//   push  OFFSET FLAT:$SG525
//   lea   ecx, DWORD PTR _b$[ebp]
//   call  ??0foo@@QAE@PBD0@Z; foo::foo
//
//
#include <stdio.h>

class foo {
  public :
    foo( int, const char *type = "integer" );
    foo( const char *, const char *type = "string" ); };

foo::foo( int, const char *type )
{
  printf( "Integer ctor, type = %s\n", type );
}

foo::foo( const char *, const char *type )
{
  printf( "String ctor, type = %s\n", type );
}

main()
{
  foo a( -1 );
  foo b( "-1" );
  return 1;
}
