///////////////////////////////////////////////////////
// trkdemo.c                                         //
// -- Demonstration program responds to messages     //
//    received from trkmouse DLL.                    //
///////////////////////////////////////////////////////
#include <windows.h>
#include <windowsx.h>
#include "mousetrk.h"

static const char szMainClass[]  = "TrackDemoMain";
static const char szChildClass[] = "TrackDemoChild";
UINT              wmMouseTrack;

LRESULT CALLBACK __export LwMainWndProc(HWND hwnd,
  UINT wm, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK __export LwChildWndProc(HWND hwnd,
  UINT wm, WPARAM wParam, LPARAM lParam);

#define cwndX     5 // Number of child window along X.
#define cwndY     5 // Number of child window along Y.
#define cwndChild (cwndX * cwndY) // Total # children.

#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain(HINSTANCE hins, HINSTANCE hinsPrev,
  LPSTR lpsz, int wShow)
    {
    HINSTANCE   Library;
    HWND    hwnd;
    MSG     msg;

    if (NULL == hinsPrev)
        { // Register the main window class.
        WNDCLASS    wcs;

        wcs.style = CS_HREDRAW | CS_VREDRAW;
        wcs.lpfnWndProc = LwMainWndProc;
        wcs.cbClsExtra = 0;
        wcs.cbWndExtra = 0;
        wcs.hInstance = hins;
        wcs.hIcon = LoadIcon(NULL, IDI_APPLICATION);
        wcs.hCursor = LoadCursor(NULL, IDC_ARROW);
        wcs.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
        wcs.lpszMenuName = NULL;
        wcs.lpszClassName = szMainClass;
        if (!RegisterClass(&wcs))
            return FALSE;

        // Register the child window class.
        wcs.style = 0;
        wcs.lpfnWndProc = LwChildWndProc;
        wcs.cbWndExtra = sizeof(BOOL);
        wcs.lpszClassName = szChildClass;
        if (!RegisterClass(&wcs))
            return FALSE;
        }

    // Get the value for the wmMouseTrack message.
    if (NULL == (wmMouseTrack =
      RegisterWindowMessage(szMouseTrack)))
        return FALSE;

    Library = LoadLibrary("mousetrk.dll");
    if((UINT)Library <= 32)
        {
        MessageBox(NULL, "Could not load mousetrk.dll", "trkdemo", MB_OK);
        return 0;
        }
    // Create the main window and enter the message
    // pump.
    msg.wParam = 0;
    if (NULL != (hwnd = CreateWindow(szMainClass,
      "Mouse Track Demo", WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
      CW_USEDEFAULT, NULL, NULL, hins, NULL)))
        {
        ShowWindow(hwnd, wShow);
        while (GetMessage(&msg, NULL, 0, 0))
            {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
            }
        }
    FreeLibrary(Library);

    return msg.wParam;
    }

LRESULT CALLBACK __export LwMainWndProc(HWND hwnd,
  UINT wm, WPARAM wParam, LPARAM lParam)
    {
    int iwnd;

    switch (wm)
        {
    default:
        break;

    case WM_CREATE: // Create 25 child windows.
        {
        HINSTANCE   hins = GetWindowInstance(hwnd);

        for (iwnd = 0; cwndChild > iwnd; iwnd++)
            if (NULL == CreateWindow(szChildClass,
              NULL, WS_CHILD | WS_BORDER | WS_VISIBLE,
              0, 0, 0, 0, hwnd, (HMENU)iwnd, hins,
              NULL))
                return -1;
        }
        break;

    case WM_SIZE: // Position the child windows.
        for (iwnd = 0; cwndChild > iwnd; iwnd++)
            {
            int iwndX = iwnd % cwndX;
            int iwndY = iwnd / cwndX;
            int x     = MulDiv(LOWORD(lParam), iwndX, cwndX);
            int y     = MulDiv(HIWORD(lParam), iwndY, cwndY);

            MoveWindow(GetDlgItem(hwnd, iwnd), x, y,
              MulDiv(LOWORD(lParam), iwndX + 1, cwndX)
                - x,
              MulDiv(HIWORD(lParam), iwndY + 1, cwndY)
                - y, TRUE);
            }
        break;

    case WM_DESTROY:
        PostQuitMessage(0);
        break;
        }

    return DefWindowProc(hwnd, wm, wParam, lParam);
    }

LRESULT CALLBACK __export LwChildWndProc(HWND hwnd,
  UINT wm, WPARAM wParam, LPARAM lParam)
    {
    if (wm == wmMouseTrack) // Remember if this window
        {                   // is under the cursor.
        SetWindowWord(hwnd, 0, wParam);
        InvalidateRect(hwnd, NULL, TRUE);
        }
    else switch (wm)
        {
    default:
        break;

    case WM_LBUTTONDOWN:   // Capture the mouse just to
        SetCapture(hwnd);  // make sure the DLL behaves
        break;             // correctly in this case.

    case WM_LBUTTONUP:
        if (GetCapture() == hwnd)
            ReleaseCapture();
        break;

    case WM_PAINT: // Paint the client area, black if
        {          // window is under mouse, else white.
        PAINTSTRUCT wps;
        RECT        rc;

        BeginPaint(hwnd, &wps);
        GetClientRect(hwnd, &rc);
        PatBlt(wps.hdc, rc.left, rc.top,
          rc.right, rc.bottom,
          0 == GetWindowWord(hwnd, 0) ?
            WHITENESS : BLACKNESS);
        EndPaint(hwnd, &wps);
        }
        return 0;
        }

    return DefWindowProc(hwnd, wm, wParam, lParam);
    }
