/*********************************************************************
                                  WINRUN 1.00
              Running (Windows and) MS-DOS programs from Windows
                        (C) Juan M. Aguirregabiria 1993
                            First version  1-05-93
                            Last revision 12-12-93
**********************************************************************/

#include <windows.h>
#pragma warn -bbf
#include <dde.h>
#pragma warn +bbf
#include "dir.h"
#include "winrun.h"

/* ------------------------[ Types ]----------------------- */

typedef struct tagICONPROPS
{
  unsigned unused:12,
           fResponse:1,
           fRelease:1,
           reserved:1,
           fAckReq:1;
  short    cfFormat;
  int      nWidth,
           nHeight;
  BYTE     nPlanes,
           nBitsPixel;
  WORD     wAnd,
           wZero1,                       /* Selector = 0 */
           wXor,
           wZer02;                       /* Selector = 0 */
  BYTE     nValue[1];
} ICONPROPS;

typedef struct {
  WORD nUnk1, nUnk2;                     /* 0010h 0010h */
  int  nWidth, nHeight;                  /* Probably */
  WORD nUnk3;                            /* 0004h */
  BYTE bBitsPixel, bPlanes;
} ICONHEAD;

#define ICONHEADLENGTH sizeof(ICONHEAD)

typedef struct {
  LPCSTR lpszCmdLine,
         lpszName;
  LPCSTR lpszDir;
  HICON  hIcon;
  UINT   fuCmdShow;
} PROGINFO;

typedef PROGINFO FAR * LPPROG;
typedef HGLOBAL         HPROG;

/* ----------------------[ Variables ]--------------------- */

static char szDesc[]        = "GetDescription",
            szDir[]         = "GetWorkingDIR",
            szIcon[]        = "GetIcon",
            szServerClass[] = "WinRun_server";

static BOOL fStarting;

/* ------------------------------[ Utilities ]------------------------------ */

void PostString(HWND hwndServer,HWND hwndClient,LPCSTR lpszString,ATOM aItem)
{
  GLOBALHANDLE hDdeData;
  DDEDATA FAR *lpDdeData;

  hDdeData = GlobalAlloc(GHND | GMEM_DDESHARE,
                         sizeof(DDEDATA)+lstrlen(lpszString));
  if (hDdeData) {
    lpDdeData = (DDEDATA FAR *)GlobalLock(hDdeData);
    if (lpDdeData) {
      lpDdeData->fResponse = 1;
      lpDdeData->fRelease  = TRUE;
      lpDdeData->fAckReq   = FALSE;
      lpDdeData->cfFormat  = 0;
      lstrcpy((LPSTR)lpDdeData->Value,lpszString);
      GlobalUnlock(hDdeData);
      if (PostMessage(hwndClient,WM_DDE_DATA,(WPARAM)hwndServer,
                         MAKELPARAM((WORD)hDdeData,(WORD)aItem))) return;
    }
    GlobalFree(hDdeData);
  }
  GlobalDeleteAtom(aItem);
}

void PostIcon(HWND hwndServer,HWND hwndClient,HICON hIcon,ATOM aItem)
{
  GLOBALHANDLE   hIconProps;
  ICONPROPS FAR *lpIconProps;
  BYTE      FAR *lpIconHead;
  int            i, l, d;

  lpIconHead = (BYTE FAR*)GlobalLock(hIcon);
  d = (GetSystemMetrics(SM_CXICON)*GetSystemMetrics(SM_CYICON))/8;
  i = ((ICONHEAD FAR*)lpIconHead)->bBitsPixel;
  l = d*(i+1)*((ICONHEAD FAR*)lpIconHead)->bPlanes; /* ??? */
  hIconProps = GlobalAlloc(GHND | GMEM_DDESHARE,sizeof(ICONPROPS)+l-1);
  if (hIconProps) {
    lpIconProps = (ICONPROPS FAR *)GlobalLock(hIconProps);
    if (lpIconProps) {
      lpIconProps->fResponse  = 1;
      lpIconProps->fRelease   = TRUE;
      lpIconProps->fAckReq    = FALSE;
      lpIconProps->cfFormat   = 0;
      lpIconProps->nWidth     = GetSystemMetrics(SM_CXICON);
      lpIconProps->nHeight    = GetSystemMetrics(SM_CYICON);
      lpIconProps->wAnd       = FIELDOFFSET(ICONPROPS,nValue);
      lpIconProps->wXor       = lpIconProps->wAnd+d;
      lpIconProps->nPlanes    = ((ICONHEAD FAR*)lpIconHead)->bPlanes;
      lpIconProps->nBitsPixel = ((ICONHEAD FAR*)lpIconHead)->bBitsPixel;
      if (l > (i = (int)GlobalSize(hIcon)-ICONHEADLENGTH))
        l = i;
      hmemcpy((void _huge *)lpIconProps->nValue,
              (const void _huge *)(lpIconHead+ICONHEADLENGTH),l);
      GlobalUnlock(hIconProps);
      if (PostMessage(hwndClient,WM_DDE_DATA,(WPARAM)hwndServer,
                         MAKELONG(hIconProps,aItem))) {
        GlobalUnlock(hIcon);
        return;
     }
    }
    GlobalFree(hIconProps);
  }
  GlobalUnlock(hIcon);
  GlobalDeleteAtom(aItem);
}

/* ------------------[ Server procedure ]------------------- */

LPARAM CALLBACK ServerProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{

  switch (msg) {

    case WM_DDE_INITIATE:
      if (fStarting) {
        ATOM aApp, aTop;
        HPROG  hProg;
        LPPROG lpProg;
        int    nCmdShow;

        hProg = (HPROG)GetWindowWord(hwnd,0);
        lpProg = GlobalLock(hProg);
        nCmdShow = lpProg->fuCmdShow;
        GlobalUnlock(hProg);
        if (nCmdShow == SW_SHOWMINNOACTIVE) nCmdShow |= SW_MINIMIZE;
        aApp = GlobalAddAtom("Shell");
        aTop = GlobalAddAtom("AppProperties");
        if (lParam == MAKELPARAM(aApp,aTop)) {
          SetWindowWord(hwnd,2,wParam);
          SendMessage((HWND)wParam,WM_DDE_ACK,
                      (WPARAM)hwnd,MAKELPARAM(aApp,aTop));
        } 
        else {
          GlobalDeleteAtom(aApp);
          GlobalDeleteAtom(aTop);
        }
      }
      return 0;

    case WM_DDE_REQUEST:
      {
        char   szItem[15];
        HPROG  hProg;
        LPPROG lpProg;

        hProg = (HPROG)GetWindowWord(hwnd,0);
        lpProg = GlobalLock(hProg);
        GlobalGetAtomName((ATOM)HIWORD(lParam),szItem,sizeof(szItem));
        if      (lpProg->lpszName && !lstrcmpi(szItem,szDesc)) 
          PostString(hwnd,(HWND)wParam,lpProg->lpszName,(ATOM)HIWORD(lParam));
        else if (lpProg->lpszDir  && !lstrcmpi(szItem,szDir ))
          PostString(hwnd,(HWND)wParam,lpProg->lpszDir ,(ATOM)HIWORD(lParam));
        else if (lpProg->hIcon    && !lstrcmpi(szItem,szIcon))
          PostIcon  (hwnd,(HWND)wParam,lpProg->hIcon   ,(ATOM)HIWORD(lParam));
        else if (!PostMessage((HWND)wParam,WM_DDE_ACK,
                    (WPARAM)hwnd,MAKELPARAM(0,HIWORD(lParam))))
          GlobalDeleteAtom(HIWORD(lParam));
        GlobalUnlock(hProg);
      }
      return 0;

    case WM_DDE_TERMINATE:

    case WM_CLOSE:
      GlobalFree((HPROG)GetWindowWord(hwnd,0));
      if (GetWindowWord(hwnd,2))
        PostMessage((HWND)GetWindowWord(hwnd,2),WM_DDE_TERMINATE,
                    (WPARAM)hwnd,0L);
      DestroyWindow(hwnd);
      return 0;
  }
  return DefWindowProc(hwnd,msg,wParam,lParam);
}

/* ---------------------[ Main proc ]----------------------- */

UINT WinRun(LPCSTR lpszCmdLine,UINT fuCmdShow,HINSTANCE hInst,
            LPCSTR lpszName,LPCSTR lpszDir,HICON hIcon)
{
  BOOL bRes;
  static BOOL fClass;
  HWND hwnd;

  if (!lpszName && !lpszDir && !hIcon)
    return WinExec(lpszCmdLine,fuCmdShow);

  if (!fClass) {
    WNDCLASS wndclass;

    wndclass.style         = 0;
    wndclass.lpfnWndProc   = ServerProc;
    wndclass.cbClsExtra    = 0;
    wndclass.cbWndExtra    = sizeof(HPROG)+sizeof(HWND);
    wndclass.hInstance     = hInst;
    wndclass.hIcon         = NULL;
    wndclass.hCursor       = NULL;
    wndclass.hbrBackground = NULL;
    wndclass.lpszMenuName  = NULL;
    wndclass.lpszClassName = szServerClass;

    RegisterClass(&wndclass);
    fClass = TRUE;
  }

  hwnd = CreateWindow(szServerClass,NULL,0,-100,-100,0,0,NULL,NULL,hInst,NULL);
  if (hwnd) {
    HPROG  hProg;
    LPPROG lpProg;

    hProg = GlobalAlloc(GHND,sizeof(PROGINFO));
    if (hProg) {
      lpProg = GlobalLock(hProg);
      lpProg->lpszCmdLine = lpszCmdLine;
      lpProg->lpszName    = lpszName   ;
      lpProg->lpszDir     = lpszDir    ;
      lpProg->hIcon       = hIcon      ;
      lpProg->fuCmdShow   = fuCmdShow  ;
      GlobalUnlock(hProg);
      SetWindowWord(hwnd,0,(WORD)hProg);
      SetWindowWord(hwnd,2,0);
    }
    else {
      DestroyWindow(hwnd);
      hwnd = NULL;
    }
  }

  fStarting = TRUE;
  bRes = WinExec(lpszCmdLine,fuCmdShow);
  fStarting = FALSE;

  if (hwnd)
    if (!GetWindowWord(hwnd,2)) SendMessage(hwnd,WM_CLOSE,0,0);
    else while (IsWindow(hwnd)) {
      MSG msg;

      while (PeekMessage(&msg,hwnd,0,0,PM_REMOVE)) {
        TranslateMessage(&msg);         /* Probably unnecessary */
        DispatchMessage(&msg);
      }
    }

  return bRes;
}
