/******************************************************************
                                 LAUNCHER 1.00
              Running (Windows and) MS-DOS programs from Windows
                        (C) Juan M. Aguirregabiria 1993
                            First version 12-12-93
                            Last revision 12-12-93
*******************************************************************/

#include <windows.h>
#include <windowsx.h>
#include <shellapi.h>
#include "winrun.h"
#include "launcher.h"

/* ---------------------[ Parameters ]--------------------- */

#define LENGTH 150

/* ----------------------[ Variables ]--------------------- */

char szProgram[LENGTH],
     szName[LENGTH],
     szDir[LENGTH],
     szIcon[LENGTH];

/* ------------------[ Dialog procedure ]------------------- */

#pragma argsused
BOOL _export CALLBACK DlgProc(HWND hDlg,UINT wMsg,WPARAM wParam,LPARAM lParam)
{
  switch (wMsg) {
    case WM_INITDIALOG:
      return TRUE;
    case WM_COMMAND:           /* Dialog box control message */
      switch (wParam) {
        case IDOK:             /* Click on OK button */
          Edit_GetText(GetDlgItem(hDlg,IDD_PROGRAM),szProgram,LENGTH);
          Edit_GetText(GetDlgItem(hDlg,IDD_NAME   ),szName   ,LENGTH);
          Edit_GetText(GetDlgItem(hDlg,IDD_DIR    ),szDir    ,LENGTH);
          Edit_GetText(GetDlgItem(hDlg,IDD_ICON   ),szIcon   ,LENGTH);
          EndDialog(hDlg,TRUE);
          return TRUE;
        case IDCANCEL:
          EndDialog(hDlg,FALSE);
          return TRUE;
      }
    break;
    case WM_SYSCOMMAND:        /* Message from dialog box system menu */
      switch (wParam) {
        case SC_CLOSE:         /* ALT+F4 or "Close"  */
          EndDialog(hDlg,FALSE);
          return FALSE;
      }
    break;
  }
  return FALSE;
}

/* -------------------[ Main procedure ]-------------------- */

#pragma argsused
int PASCAL WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,
                   LPSTR lpszCmdLine,int nCmdShow)
{
  HICON    hIcon;

  if (DialogBox(hInstance,MAKEINTRESOURCE(IDD_DIALOG),NULL,DlgProc)) {
    SetCursor(LoadCursor(NULL,IDC_WAIT));
    ShowCursor(TRUE);
    hIcon = (*szIcon) ? ExtractIcon(hInstance,szIcon,0) : NULL;
    if (hIcon == (HICON)1) hIcon = NULL;
    WinRun(szProgram,nCmdShow,hInstance,
        (*szName) ? szName : NULL,(*szDir)  ? szDir : NULL,hIcon);
    if (hIcon) DestroyIcon(hIcon);
    SetCursor(LoadCursor(NULL,IDC_ARROW));
    ShowCursor(FALSE);
  }
  return 0;
}
