// w_uiutil.c - generally useful routines for building
//              a WUIMAN user interface
// Copyright (c) 1994 by Ron Burk

#include <stdio.h>
#include "w_uiutil.h"

long    WuiGet(size_t LineNumber, const char *FileName,
                 const char *Path, const char *Attribute,
                          char *Result, size_t MaxLength)
    {
    long    Status = WUIMAN_Get(Path, Attribute, Result, MaxLength);
    if(Status < WUIMAN_ERRORS)
        {
        char Location[256];
        sprintf(Location, "Line %d, File '%s'", LineNumber, FileName);
        int Answer = MessageBox(NULL, WUIMAN_LastError, Location, MB_OKCANCEL);
        if(Answer == IDCANCEL)
            FatalAppExit(0, "I hope this does not crash!");
        }
    return Status;
    }

long    WuiSet(size_t LineNumber, const char *FileName,
                    const char *Path, const char *Attribute,
                                         const char *Result)
    {
    long    Status = WUIMAN_Set(Path, Attribute, Result);
    if(Status < WUIMAN_ERRORS)
        {
        char Location[256];
        sprintf(Location, "Line %d, File '%s'", LineNumber, FileName);
        int Answer = MessageBox(NULL, WUIMAN_LastError, Location, MB_OKCANCEL);
        if(Answer == IDCANCEL)
            FatalAppExit(0, "I hope this does not crash!");
        }
    return Status;
    }


long    WuiGetBit(const char *Path, const char *Property,
                const char *BitName)
    {
    char    Attribute[64];
    sprintf(Attribute, "m_Attribute('%s', '%s')",
                                        Property, BitName);
    return WUIGET(Path, Attribute, NULL, 0);
    }

long    WuiSetBit(const char *Path, const char *Property,
                const char *BitName, int On)
    {
    char    Attribute[64];
    sprintf(Attribute, "m_Attribute('%s', '%s', %d)",
                                    Property, BitName, On);
    return WUISET(Path, Attribute, NULL);
    }

