// w_atom.h - class to handle global atoms
// Copyright (c) 1993 by Ron Burk

#ifndef W_ATOM_H
#define W_ATOM_H

#if !(defined(_INC_WINDOWS) || defined(__WINDOWS_H))
    #include <windows.h>
#endif
#if !defined(WUISTD_H)
    #include "wuistd.h"
#endif

class   TGlobalAtom
    {
public:
    TGlobalAtom(const char *AtomName);
    TGlobalAtom(const TGlobalAtom& Atom);
   ~TGlobalAtom();
    TGlobalAtom& operator=(const TGlobalAtom& Atom);
    operator ATOM() const;
    HANDLE  GetProperty(HWND Window) const;
    int     SetProperty(HWND Window, HANDLE Value);
    // unsigned short is often more convenient
    int     SetProperty(HWND Window, unsigned short Value);
    HANDLE  RemoveProperty(HWND Window) const;
private:
    ATOM    GlobalAtom;
    };

inline
int     TGlobalAtom::SetProperty(HWND Window,
                                       unsigned short Value)
    {   MEMBERASSERT();
    return SetProperty(Window, (HANDLE)Value);
    }

inline
TGlobalAtom::operator ATOM() const
    {   MEMBERASSERT();
    return GlobalAtom;
    }

#endif // W_ATOM_H
