// wuistd.c - general utility code.
// Copyright (c) 1993 by Ron Burk

#include <string.h>
#include "wuistd.h"
#include "w_hook.h"
#include <stdarg.h>
#include <stdio.h>
#include <windows.h>

char    *StringClone(const char *Input)
    {
    ASSERT(Input != NULL);
    size_t  Size = strlen(Input)+1;
    char *Result = new char[Size];
    ASSERT(Result != NULL);
    return (char *)memcpy(Result, Input, Size);
    }

TCharBuffer::TCharBuffer(size_t BufferSize)
    :   Size_(BufferSize)
    {   MEMBERASSERT();
    Buffer  = new char[BufferSize];
    ASSERT(Buffer != NULL);
    }

// copy constructor
TCharBuffer::TCharBuffer(const TCharBuffer &Other)
    :   Buffer(NULL), Size_(0)
    {   MEMBERASSERT();
    // Let assignment operator do the work
    *this   = Other;
    }

// assignment operator
const TCharBuffer &TCharBuffer::operator=(const TCharBuffer &Other)
    {   MEMBERASSERT();
    if(this != &Other)  // handle assignment to self
        {
	if(Buffer)  // if not called by copy constructor
            delete[] Buffer;
        Buffer  = new char[Other.Size_];
        ASSERT(Buffer != NULL);
        Size_    = Other.Size_;
        memcpy(Buffer, Other.Buffer, Other.Size_);
        }
    return *this;
    }

// destructor - free up resource
TCharBuffer::~TCharBuffer()
    {   MEMBERASSERT();
    if(Buffer)
        delete[] Buffer;
    }

#if 0
#ifdef __BORLANDC__
extern "C" {
    extern void FAR _cdecl DEBUGOUTPUT(UINT, LPCSTR, ...);
    };
#endif
#endif

// static variable to remember most recent message type
// (tacky, but effective)

static char MessageType = 't';


void    DebugPrintf(char Type, const char *Format, va_list Args)
    {
    char    *Message = "No memory for DebugPrintf().\r\r\n";
    char    *Buffer  = new char[1000];
    if(Buffer)
        {
        char    *Append = Buffer;
        sprintf(Buffer, "%c ", Type);
        Append  = Buffer + strlen(Buffer);
        vsprintf(Append, Format, Args);
        Message = Buffer;
        }
    if(Message[strlen(Message)-1] == '\n')
        Message[strlen(Message)-1] = '\0';
    OutputDebugString(Message);
    if(Type == '\0')
        OutputDebugString("\r\n");
    if(Type == '\0' && MessageType == 'f')
        {
        // So BoundsChecker will give stack traceback
        GlobalLock(0);
        FatalAppExit(0, Message);
        }

    if(Buffer)
        delete[] Buffer;
    }

void    DebugPrintf(const char *Format, ...)
    {
    va_list Args;
    va_start(Args, Format);
    DebugPrintf('\0', Format, Args);
    va_end(Args);
    }

void    DebugPrintf(char Type, const char *Format, ...)
    {
    va_list Args;
    va_start(Args, Format);
    MessageType = Type;
    DebugPrintf(Type, Format, Args);
    va_end(Args);
    }

void    AssertionFailure(char *File, int LineNumber,
                                                 char *Text)
    {
    DebugPrintf('f', "%-12s %04d Assertion Failed:'%s'",
        File, LineNumber, Text);
    }

