#include <stdio.h>
#include <string.h>
#include <windows.h>
#include "wuistd.h"
#include "wuiobjdb.h"
#include "wuidbint.h"
#include "wuiman.h"


#if defined(__SC__)
    const char *Compiler = "Symantec";
#elif defined(__BORLANDC__)
    const char *Compiler = "Borland";
#elif defined(__MSC)
    const char *Compiler = "Microsoft";
#else
    const char *Compiler = "Unknown";
#endif


static
long    LoadDatabase(TWuiPath Path, AWuiObject *Node);


HINSTANCE   WUIMAN_Instance;

long    WUIMAN_Get(const char *Path, const char *Attribute,
                          char *Result, size_t ResultLength)
    {
    long    Status = 0;
    if(!Path)
        Path    = "<NULL>";
    if(AWuiObject::TraceFlag)
        DEBUG_TRACE(">>WUIMAN_Get(Path='%s',Attribute='%s')",
                                           Path, Attribute);
    if(Path[0] != '/')
        Status  = WUIMAN_ERR_BAD_PATH;
    else if(!AWuiObject::Database || !AWuiObject::Root)
        Status = WUIMAN_ERR_NOT_INITIALIZED;
    else
        {
        if(Result)
            *Result = '\0';
        char    ModifiablePath[512];
        strcpy(ModifiablePath, Path);
        TWuiArgs    Args(Attribute);
        if(Args.AttributeName() == "")
            Status = WUIMAN_ERR_CANT_PARSE_ATTR;
        else
            Status = AWuiObject::Root->Get(ModifiablePath,
                         &Args, NULL, Result, ResultLength);
        }
    if(AWuiObject::TraceFlag)
        DEBUG_TRACE("<<WUIMAN_Get returns [%ld] \"%s\"",
                            Status, Result?Result:"<NULL>");
    if(Status < WUIMAN_ERRORS)
        {
        const char *Null = "<NULL>";
        sprintf(WUIMAN_LastError, "WUIMAN_Get(\"%s\", "
                    "\"%s\", \"%s\", %u)\n", Path?Path:Null,
               Attribute?Attribute:Null, Result?Result:Null,
                                              ResultLength);
        WUIMAN_Error(Status,
                 WUIMAN_LastError+strlen(WUIMAN_LastError));
        DEBUG_TRACE("%s", WUIMAN_LastError);
        }
    return Status;
    }

long    WUIMAN_Set(const char *Path, const char *Attribute,
                                          const char *Value)
    {
    long    Status = 0;
    if(!Path)
        Path    = "<NULL>";
    if(AWuiObject::TraceFlag)
        DEBUG_TRACE(">>WUIMAN_Set(Path='%s',Attribute='%s', Value='%s')",
                                           Path, Attribute, Value);
    if(Path[0] != '/')
        Status  = WUIMAN_ERR_BAD_PATH;
    else if(!AWuiObject::Database || !AWuiObject::Root)
        Status = WUIMAN_ERR_NOT_INITIALIZED;
    else
        {
        char        ModifiablePath[512];
        strcpy(ModifiablePath, Path);
        TWuiArgs    Args(Attribute);
        Status  = AWuiObject::Root->Set(ModifiablePath,
                                        &Args, NULL, Value);
        }
    if(AWuiObject::TraceFlag)
        DEBUG_TRACE("<<WUIMAN_Set returns [%ld]", Status);
    if(Status < WUIMAN_ERRORS)
        {
        const char *Null = "<NULL>";
        sprintf(WUIMAN_LastError, "WUIMAN_Set(\"%s\", "
                    "\"%s\", \"%s\")\n", Path?Path:Null,
                Attribute?Attribute:Null, Value?Value:Null);
        WUIMAN_Error(Status,
                 WUIMAN_LastError+strlen(WUIMAN_LastError));
        DEBUG_TRACE("%s", WUIMAN_LastError);
        }
    return Status;
    }

long    WUIMAN_Open(HINSTANCE Instance, const char *IniFileName)
    {
    DEBUG_TRACE("WUIMAN_Open(). This version of "
                     "WUIMAN compiled with %s C++. "
            "WUIMAN_ERRORS=%ld\n", Compiler, WUIMAN_ERRORS);
    long    Status = 0;
    if(AWuiObject::TraceFlag)
        DEBUG_TRACE(">>WUIMAN_Open(Instance, IniFileName='%s')",
                           IniFileName?IniFileName:"<NULL>");
    WUIMAN_Instance         = Instance;
    TWuiDatabase  *Database = new TWuiDatabase(IniFileName);
    AWuiObject::Database    = Database;
    // if root does not exist, create it
    if(Database->ReadItem("/", ".p_WuimanVersion", NULL, 0) == -1)
        {
        Database->WriteItem("/", ".p_WuimanVersion",
            "TAttributeString,0x02,0.0");
        }
    if(Database->ReadItem("/", ".p_WuimanVersion", NULL, 0) == -1)
        Status  = WUIMAN_ERR_DATABASE_INIT;
    else
        {
        char    ModifiablePath[512];
        strcpy(ModifiablePath, "/");
        Status = LoadDatabase(ModifiablePath, AWuiObject::Root);
        }
    if(AWuiObject::TraceFlag)
        DEBUG_TRACE("<<WUIMAN_Open returns [%ld]", Status);
    return Status;
    }

long    WUIMAN_Close()
    {
    if(AWuiObject::Database != NULL)
        delete AWuiObject::Database;
    if(AWuiObject::Root != NULL)
        delete AWuiObject::Root;
    return TRUE;
    }



static
long    LoadDatabase(TWuiPath Path, AWuiObject *Node)
    {
    long    Status = 0;
    TWuiDatabaseKeys *Keys  = AWuiObject::Database->
                               GetKeys(Path.AbsolutePath());
    if(Keys == NULL)
        DEBUG_FATAL("Database damaged, path '%s' "
                "has no attributes or children.",
                    Path.AbsolutePath());
    const int MAX_ITEM = 1024;
    TCharBuffer NodeData(MAX_ITEM);
    // first, load the attributes, creating when necessary.
    const char *Name = Keys->FirstKey();
    TWuiObjects *List = Node->Attributes();
    if(List)    // if object supports attributes
        for(; Name != NULL; Name = Keys->NextKey())
            {
            // Read class name, value string
            AWuiObject::Database->ReadItem(
                                  Path.AbsolutePath(), Name,
                                        NodeData, MAX_ITEM);
            if(*Name++ != '.')  // if not attribute
                continue;
            char *Value = strchr(NodeData, ',');
            if(Value)
                *Value++    = '\0';
            AWuiObject *Attribute = List->Get(Name);
            // if object did not create this attribute
            if(!Attribute)
                { // then create it ourselves
                Attribute   = AWuiObject::New(TWuiName(NodeData), Name);
                if(Attribute)
                    List->Insert(Attribute);
                else
                    continue;
                }
            Status = Attribute->Initialize(Value);
            if(Status < WUIMAN_ERRORS)
                {
                DEBUG_ERROR("Could not initialize '%s.%s' with value '%s'",
                        Path.AbsolutePath(), (char *)Name, Value);
                continue;
                }
            }

    // Now load child nodes recursively
    Name    = Keys->FirstKey();
    List    = Node->Children();
    if(List)    // if object supports child nodes
        for(; Name != NULL; Name = Keys->NextKey())
            {
            // Read class name, value string
            AWuiObject::Database->ReadItem(
                                  Path.AbsolutePath(), Name,
                                        NodeData, MAX_ITEM);
            if(*Name++ == '.')  // skip attributes
                continue;
            char *Value = strchr(NodeData, ',');
            if(Value)
                *Value++    = '\0';
            AWuiObject *ChildNode = AWuiObject::New(
                                  TWuiName(NodeData), Name);
            if(!ChildNode)
                continue;
            ChildNode->Initialize(Value);
            List->Insert(ChildNode);
            Path.Push(Name);
            LoadDatabase(Path, ChildNode);
            Path.Pop();
            }
    delete  Keys;
    return 1;
    }

