// wuidbint.h - WUIMAN DataBase INTerface declarations
// Copyright (c) 1993 by Ron Burk

#ifndef WUIDBINT_H
#define WUIDBINT_H

#include <stdlib.h>
#ifndef WUINAME_H
    #include "wuiname.h"
#endif

class   TWuiDatabaseKeys;
class   TWuiDatabase
    {
public:
    TWuiDatabase(const char *Database);
   ~TWuiDatabase();
    int     WriteItem(const char *Path, TWuiName Item,
                                          const char *Data);
    int     ReadItem(const char *Path, TWuiName Item,
                               char *Buffer, int Length);
    TWuiDatabaseKeys *GetKeys(const char *Path);
    int     DeleteItem(const char *Path, const char *Item);
    int     DeletePath(const char *Path);
private:
    char   *DatabaseName_;
    };

class   TWuiDatabaseKeys
    {
public:
   ~TWuiDatabaseKeys();
    const char *FirstKey();
    const char *NextKey();
private:
friend TWuiDatabase;
    TWuiDatabaseKeys(char *Keys);
    char            *Keys_;
    char            *Current_;
    };

#endif
