/*
 *  ctl3d.c - dynamic interface to ctl3d.dll
 *
 *  The basic idea is that you want to take advantage of ctl3d.dll
 *  if it is present, but just default to 2D UI if it is not (rather
 *  than emitting a nasty error message and quitting). This file
 *  provides wrapper functions that call the corresponding entry
 *  points in ctl3d.dll if it is present.  Otherwise, these routines
 *  become stubs that do nothing.
 */


#include <windows.h>
#include "ctl3d.h"

struct  LibraryRoutine
    {
    FARPROC Function;
    char    *Name;
    };

LibraryRoutine  FunctionTable[] =
    {
        { NULL, "Ctl3dSubclassDlg" },
        { NULL, "Ctl3dSubclassDlgEx" },
        { NULL, "Ctl3dGetVer" },
        { NULL, "Ctl3dEnabled" },
        { NULL, "Ctl3dCtlColor" },
        { NULL, "Ctl3dCtlColorEx" },
        { NULL, "Ctl3dColorChange" },
        { NULL, "Ctl3dSubclassCtl" },
        { NULL, "Ctl3dDlgFramePaint" },
        { NULL, "Ctl3dAutoSubclass" },
        { NULL, "Ctl3dRegister" },
        { NULL, "Ctl3dUnregister" }
    };
#define NFUNCTIONS  (sizeof(FunctionTable)/sizeof(LibraryRoutine))

BOOL    (FAR PASCAL *&Ctl3dSubclassDlg_)(HWND, WORD)
        = (BOOL (FAR PASCAL *&)(HWND,WORD))FunctionTable[0].Function;
BOOL    (FAR PASCAL *&Ctl3dSubclassDlgEx_)(HWND, DWORD)
        = (BOOL (FAR PASCAL *&)(HWND,DWORD))FunctionTable[1].Function;
WORD    (FAR PASCAL *&Ctl3dGetVer_)()
        = (WORD (FAR PASCAL *&)())FunctionTable[2].Function;
BOOL    (FAR PASCAL *&Ctl3dEnabled_)()
        = (BOOL (FAR PASCAL *&)())FunctionTable[3].Function;
HBRUSH  (FAR PASCAL *&Ctl3dCtlColor_)(HDC, LONG)
        = (HBRUSH (FAR PASCAL *&)(HDC,LONG))FunctionTable[4].Function;
HBRUSH  (FAR PASCAL *&Ctl3dCtlColorEx_)(UINT, WPARAM, LPARAM)
        = (HBRUSH (FAR PASCAL *&)(UINT,WPARAM,LPARAM))FunctionTable[5].Function;
BOOL    (FAR PASCAL *&Ctl3dColorChange_)()
        = (BOOL (FAR PASCAL *&)())FunctionTable[6].Function;
BOOL    (FAR PASCAL *&Ctl3dSubclassCtl_)(HWND)
        = (BOOL (FAR PASCAL *&)(HWND))FunctionTable[7].Function;
LONG    (FAR PASCAL *&Ctl3dDlgFramePaint_)(HWND, UINT, WPARAM, LPARAM)
        = (LONG (FAR PASCAL *&)(HWND,UINT,WPARAM,LPARAM))FunctionTable[8].Function;
BOOL    (FAR PASCAL *&Ctl3dAutoSubclass_)(HANDLE)
        = (BOOL (FAR PASCAL *&)(HANDLE))FunctionTable[9].Function;
BOOL    (FAR PASCAL *&Ctl3dRegister_)(HANDLE)
        = (BOOL (FAR PASCAL *&)(HANDLE))FunctionTable[10].Function;
BOOL    (FAR PASCAL *&Ctl3dUnregister_)(HANDLE)
        = (BOOL (FAR PASCAL *&)(HANDLE))FunctionTable[11].Function;


class TInitCtl3d
    {
public:
    TInitCtl3d();
    };

TInitCtl3d::TInitCtl3d()
    {
    HINSTANCE   Library = LoadLibrary("ctl3d.dll");
    if(Library > HINSTANCE_ERROR)
        for(int i=0; i < NFUNCTIONS; ++i)
            FunctionTable[i].Function   = GetProcAddress(
                            Library, FunctionTable[i].Name);
    }

static  TInitCtl3d Dummy;



extern "C" {

BOOL FAR PASCAL Ctl3dSubclassDlg(HWND Window, WORD Flags)
    {
    if(Ctl3dSubclassDlg_)
        return Ctl3dSubclassDlg_(Window, Flags);
    else
        return FALSE;
    }

BOOL FAR PASCAL Ctl3dSubclassDlgEx(HWND Window, DWORD Flags)
    {
    if(Ctl3dSubclassDlgEx_)
        return Ctl3dSubclassDlgEx_(Window, Flags);
    else
        return FALSE;
    }


WORD FAR PASCAL Ctl3dGetVer(void)
    {
    if(Ctl3dGetVer_)
        return Ctl3dGetVer_();
    else
        return 0;
    }
BOOL FAR PASCAL Ctl3dEnabled(void)
    {
    if(Ctl3dEnabled_)
        return Ctl3dEnabled_();
    else
        return 0;
    }
HBRUSH FAR PASCAL Ctl3dCtlColor(HDC Device, LONG Param1)
    {
    if(Ctl3dCtlColor_)
        return Ctl3dCtlColor_(Device, Param1);
    else
        return (HBRUSH)0;
    }
HBRUSH FAR PASCAL Ctl3dCtlColorEx(UINT Message, WPARAM Param1, LPARAM Param2)
    {
    if(Ctl3dCtlColorEx_)
        return Ctl3dCtlColorEx_(Message, Param1, Param2);
    else
        return (HBRUSH)0;
    }
BOOL FAR PASCAL Ctl3dColorChange(void);
BOOL FAR PASCAL Ctl3dSubclassCtl(HWND);
LONG FAR PASCAL Ctl3dDlgFramePaint(HWND, UINT, WPARAM, LPARAM);

BOOL FAR PASCAL Ctl3dAutoSubclass(HANDLE Instance)
    {
    if(Ctl3dAutoSubclass_)
        return Ctl3dAutoSubclass_(Instance);
    else
        return FALSE;
    }

BOOL FAR PASCAL Ctl3dRegister(HANDLE Instance)
    {
    if(Ctl3dRegister_)
        return Ctl3dRegister_(Instance);
    else
        return FALSE;
    }
BOOL FAR PASCAL Ctl3dUnregister(HANDLE Instance)
    {
    if(Ctl3dUnregister_)
        return Ctl3dUnregister_(Instance);
    else
        return FALSE;
    }

};


