/*****************************************************/
/* mdiclick.c                                        */
/*  -- Control mouse clicks when activating an mdi   */
/*     window.                                       */
/*****************************************************/
#include <windows.h>

LRESULT LwHandleHitTest(HWND hwnd, HWND hwndClient,
  WPARAM wParam, LPARAM lParam)
/*****************************************************/
/* -- Handle a WM_NCHITTEST message on an MDI child  */
/*    window to suppress WM_LBUTTONxx messages when  */
/*    an inactive window is clicked.                 */
/* -- hwnd           : MDI child window.             */
/* -- hwndClient     : MDI client window.            */
/* -- wParam, lParam : Message parameters.           */
/*****************************************************/
    {
    LRESULT lVal;

    lVal = DefMDIChildProc(hwnd, WM_NCHITTEST, wParam,
      lParam);
    if (GetAsyncKeyState(VK_LBUTTON) < 0 &&
      (HWND)LOWORD(SendMessage(hwndClient,
        WM_MDIGETACTIVE, 0, 0)) != hwnd &&
      lVal == HTCLIENT)
       return HTMENU;

    return lVal;
    }
