/*****************************************************/
/* caption.c                                         */
/* -- Implements a captioned edit control using a    */
/*    top level and child window.                    */
/*****************************************************/
#include <windows.h>
#include <windowsx.h>

LRESULT CALLBACK __export LwWndProc(HWND hwnd, UINT wm,
  WPARAM wParam, LPARAM lParam);

char szClass[] = "Caption2"; // Class name.

#define cidEdit 1000 // Edit's control ID.

int PASCAL WinMain(HINSTANCE hins, HINSTANCE hinsPrev,
  LPSTR lpsz, int wShow)
/*****************************************************/
/* -- Entry point.                                   */
/*****************************************************/
    {
    HWND     hwnd;
    MSG      msg;
    WNDCLASS wcs;

    if (NULL == hinsPrev)
        {
        wcs.style = CS_HREDRAW | CS_VREDRAW;
        wcs.lpfnWndProc = LwWndProc;
        wcs.cbClsExtra = 0;
        wcs.cbWndExtra = 0;
        wcs.hInstance = hins;
        wcs.hIcon = LoadIcon(NULL, IDI_APPLICATION);
        wcs.hCursor = LoadCursor(NULL, IDC_ARROW);
        wcs.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
        wcs.lpszMenuName = NULL;
        wcs.lpszClassName = szClass;
        if (!RegisterClass(&wcs))
            return FALSE;
        }

    msg.wParam = 0;
    if (NULL != (hwnd = CreateWindow(szClass,
      "Hi there!", WS_OVERLAPPEDWINDOW, CW_USEDEFAULT,
      CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
      NULL, NULL, hins, NULL)))
        {
        ShowWindow(hwnd, wShow);
        while (GetMessage(&msg, NULL, 0, 0))
            {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
            }
        }

    return msg.wParam;
    }

LRESULT CALLBACK __export LwWndProc(HWND hwnd, UINT wm,
  WPARAM wParam, LPARAM lParam)
/*****************************************************/
/* -- Main window procedure.                         */
/*****************************************************/
    {
    switch (wm)
        {
    default:
        break;

    case WM_CREATE:
        if (NULL == CreateWindow("edit",
          "this is some text", WS_VISIBLE | WS_CHILD |
            WS_HSCROLL | WS_VSCROLL | ES_MULTILINE,
          0, 0, 0, 0, hwnd, (HMENU)cidEdit,
          GetWindowInstance(hwnd), NULL))
            return -1;
        break;

    case WM_SIZE:
        SetWindowPos(GetDlgItem(hwnd, cidEdit), NULL,
          0, 0, LOWORD(lParam), HIWORD(lParam),
          SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOZORDER);
        break;

    case WM_DESTROY:
        PostQuitMessage(0);
        break;
        }

    return DefWindowProc(hwnd, wm, wParam, lParam);
    }
