#ifndef ODS_H
#define ODS_H
// ods
// Output Debug Stream
// John Gmutza, Postek Inc.
#ifndef __IOMANIP_H
#include <iomanip.h>
#endif
#ifndef __STRSTREAM_H
#include <strstrea.h>
#endif

template<int SIZ = 256> class ODS: public ostrstream {
public:
  ODS() :ostrstream(buf, sizeof buf) { *buf = '\0'; }

protected:
  char buf[SIZ];  // the output buffer
};

// manipulator to trigger debug output via
// OutputDebugString()
ostream& dump(ostream &os) {
  ostrstream &oss = (ostrstream &)os;
// null-terminate current data
  oss << ends;
// get the string
  char *buf = oss.str();
// output string to debugger
  OutputDebugString(buf);
// unfreeze and reset streambuf
  oss.rdbuf()->freeze(0);
  oss.rdbuf()->seekpos(0);
  return os;
} /* dump */
#endif


