#ifndef ODS_H
#define ODS_H
// ods
// Output Debug Stream
// John Gmutza, Postek Inc.
// Use freely, but please credit author!
#ifndef __OWL_H
#include <owl.h>
#endif
#ifndef __IOMANIP_H
#include <iomanip.h>
#endif
#ifndef __STRSTREAM_H
#include <strstrea.h>
#endif

class debugstreambuf: public strstreambuf {
public:
  debugstreambuf(char *buf, size_t siz, char *st) :strstreambuf(buf, siz, st) { };
  debugstreambuf() :strstreambuf() { };

  int sync() {
    int ret = strstreambuf::sync();
  // null-terminate
    sputc('\0');
  // output string to debugger
    char *buf = str();
    OutputDebugString(buf);
  // reset string
    seekoff(0, ios::beg, ios::out);
    return ret;
  } /* sync */
};

class debugstreambase: public virtual ios {
public:
  strstreambuf _FAR * _Cdecl rdbuf() { return (strstreambuf _FAR *)&this->buf; }

protected:
  _Cdecl debugstreambase(char *ptr, int n, char *start) :buf(ptr, n, start) {
    ios::init(&this->buf);
  }
  _Cdecl debugstreambase() :buf() { ios::init(&this->buf); }

private:
  debugstreambuf buf;
};

template<int SIZ = 256> class ODS: public debugstreambase, public ostream {
public:
  ODS() :debugstreambase(buf, sizeof buf, NULL), ostream(debugstreambase::rdbuf()) {
    *buf = '\0';
    debugstreambase::rdbuf()->seekoff(0, ios::beg, ios::out);
  }

protected:
  char buf[SIZ];  // the output buffer
};
#endif


