#
#   Microsoft NMake file for STEPPER
#
#   NOTE:  The DEBUG.C file assumes that FOO.EXE was compiled
#   with Borland's tools.  To compile and run it with Microsoft
#   tools, you must make some simple modifications as described
# 	in the article.

all: stepper.exe
stepper.exe: stepper.obj bpnode.obj debug.obj stepper.rbj
stepper.obj: stepper.c stepper.h rsrc.h
bpnode.obj: bpnode.c stepper.h
debug.obj: debug.c stepper.h
stepper.rbj: stepper.rc stepper.ico rsrc.h

#
#   Define macros for command line options and library modules
#

!IFDEF NODEBUG
CFLAGS = -c -Os -W3 -D_X86_=1 -DWIN32 -D_MT
LFLAGS =
!ELSE
CFLAGS = -c -Od -W3 -Zi -D_X86_=1 -D_MT -DWIN32
LFLAGS = -debug:full -debugtype:cv
!ENDIF
SUBSYS = -subsystem:windows

LIBS = libcmt.lib kernel32.lib user32.lib gdi32.lib shell32.lib
OBJS = debug.obj bpnode.obj

#
#   Define compiling rules
#

.c.obj:
     cl386 $(CFLAGS) $*.c

.rc.rbj:
   rc $*.rc
   cvtres -i386 $*.res -o $*.rbj

.obj.exe:
    link32 $(LFLAGS) $(SUBSYS) -out:$*.exe $*.obj $(OBJS) $*.rbj $(LIBS)
