#
#   Borland makefile for STEPPER
#

stepper.exe: stepper.obj bpnode.obj debug.obj stepper.res
stepper.obj: stepper.c stepper.h rsrc.h
bpnode.obj: bpnode.c stepper.h
debug.obj: debug.c stepper.h
stepper.res: stepper.rc stepper.ico rsrc.h

LIBS = cw32mt import32 
OBJS = stepper bpnode debug
STARTUP = c0w32
LIBDIR = c:\bc4\lib
INCDIR = c:\bc4\include

# options for a multithreaded Windows subsystem .EXE file
!IFDEF NODEBUG
CFLAGS = -3 -a2 -H -Ox -WM -I$(INCDIR)
LFLAGS = -aa -L$(LIBDIR)
!ELSE
CFLAGS = -3 -H -WM -v -I$(INCDIR)
LFLAGS = -aa -v -L$(LIBDIR)
!ENDIF

#
#   Define compiling rules
#

.dll.lib:
	implib $*.lib $*.dll

.c.obj:
	bcc32 -c $(CFLAGS) $<

.rc.res:
	brcc32 -i$(INCDIR) $&

.obj.exe:
	tlink32 -Tpe $(LFLAGS) $(STARTUP) $(OBJS), $*,, $(LIBS),, $*

.obj.dll:
	tlink32 -Tpd $(LFLAGS) c0d32 $*, $*,, $(LIBS)


#	BCC32 NOTES
#	-W	32-bit GUI application
#	-WC	32-bit console application
#	-WD	32-bit GUI DLL with all functions exportable
#	-WCD	32-bit console DLL with all functions exportable 
#	-WE	EXE or DLL explicit functions exportable and exported
#	-WM	EXE or DLL multithreaded 

#	TLINK32 NOTES
# 	-Tpe = PE .EXE
#	-Tpd = PE .DLL
#	-ap  = console subsystem
#	-aa  = Windows subsystem

#	LIB/OBJ NOTES
#	cw32		RTL: static link
#	cw32i		RTL: dynamic link
#	cw32mt		RTL: multithreaded static
#	cw32mti		RTL: multithreaded dynamic
#	import32	Win32 API
#	cod32.obj	DLL startup
#	c0x32.obj	console app startup
#	c0w32.obj	GUI app startup
