#
#   Microsoft NMake file for DEBUG TRACE
#

all: dbtrace.exe
dbtrace.exe: dbtrace.obj dbtrace.rbj 

#
#   Define macros for command line options and library modules
#

!IFDEF NODEBUG
CFLAGS = -c -Os -W3 -D_X86_=1 -DWIN32 -D_MT
LFLAGS =
!ELSE
CFLAGS = -c -Od -W3 -Zi -D_X86_=1 -D_MT -DWIN32
LFLAGS = -debug:full -debugtype:cv
!ENDIF
SUBSYS = -subsystem:windows

LIBS = libcmt.lib kernel32.lib user32.lib comdlg32.lib

#
#   Define compiling rules
#

.c.obj:
     cl386 $(CFLAGS) $*.c

.rc.rbj:
   rc $*.rc
   cvtres -i386 $*.res -o $*.rbj

.obj.exe:
    link32 $(LFLAGS) $(SUBSYS) -out:$*.exe $*.obj $*.rbj $(LIBS)
