/*
 * Decompiled with CFR 0.152.
 */
package io.kotlintest.runner.jvm;

import arrow.Kind;
import arrow.core.NonFatal;
import arrow.core.Try;
import io.kotlintest.Project;
import io.kotlintest.Spec;
import io.kotlintest.TestCaseFilter;
import io.kotlintest.runner.jvm.JvmKt;
import io.kotlintest.runner.jvm.TestEngine;
import io.kotlintest.runner.jvm.TestEngineKt;
import io.kotlintest.runner.jvm.TestEngineListener;
import io.kotlintest.runner.jvm.TryfuncsKt;
import io.kotlintest.runner.jvm.internal.NamedThreadFactory;
import io.kotlintest.runner.jvm.spec.SpecExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0014\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b2\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004H\u0002J\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u0006\u0010\"\u001a\u00020\u001cJ\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J&\u0010%\u001a\u00020\u001c2\u0014\u0010&\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010'\u001a\u00020\u001c2\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00042\u0006\u0010(\u001a\u00020)H\u0002R\u001f\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\n \u0013*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lio/kotlintest/runner/jvm/TestEngine;", "", "classes", "", "Lkotlin/reflect/KClass;", "Lio/kotlintest/Spec;", "filters", "Lio/kotlintest/TestCaseFilter;", "parallelism", "", "listener", "Lio/kotlintest/runner/jvm/TestEngineListener;", "(Ljava/util/List;Ljava/util/List;ILio/kotlintest/runner/jvm/TestEngineListener;)V", "getClasses", "()Ljava/util/List;", "getListener", "()Lio/kotlintest/runner/jvm/TestEngineListener;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getParallelism", "()I", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "specExecutor", "Lio/kotlintest/runner/jvm/spec/SpecExecutor;", "afterAll", "Larrow/core/Try;", "", "createSpec", "klass", "end", "t", "", "execute", "start", "submitAll", "submitBatch", "specs", "submitSpec", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlintest-runner-jvm"})
public final class TestEngine {
    private final Logger logger;
    private final ScheduledExecutorService scheduler;
    private final SpecExecutor specExecutor;
    @NotNull
    private final List<KClass<? extends Spec>> classes;
    private final int parallelism;
    @NotNull
    private final TestEngineListener listener;

    private final Try<Unit> afterAll() {
        Try try_;
        Try.Companion this_$iv = Try.Companion;
        try {
            Unit unit;
            boolean bl = false;
            Project.INSTANCE.afterAll();
            Unit unit2 = unit = Unit.INSTANCE;
            try_ = (Try)new Try.Success((Object)unit2);
        }
        catch (Throwable e$iv) {
            if (!NonFatal.INSTANCE.invoke(e$iv)) {
                throw e$iv;
            }
            try_ = (Try)new Try.Failure(e$iv);
        }
        return try_;
    }

    private final Try<Unit> start() {
        Try try_;
        Try.Companion this_$iv = Try.Companion;
        try {
            Unit unit;
            boolean bl = false;
            this.listener.engineStarted(this.classes);
            Project.INSTANCE.beforeAll();
            Unit unit2 = unit = Unit.INSTANCE;
            try_ = (Try)new Try.Success((Object)unit2);
        }
        catch (Throwable e$iv) {
            if (!NonFatal.INSTANCE.invoke(e$iv)) {
                throw e$iv;
            }
            try_ = (Try)new Try.Failure(e$iv);
        }
        return try_;
    }

    /*
     * WARNING - void declaration
     */
    private final Try<Unit> submitAll() {
        Try try_;
        Try.Companion this_$iv = Try.Companion;
        try {
            Unit unit;
            void single;
            Pair pair;
            boolean bl = false;
            this.logger.trace("Submitting " + this.classes.size() + " specs");
            List specs = Project.INSTANCE.specExecutionOrder().sort(this.classes);
            if (this.parallelism == 1) {
                pair = TuplesKt.to((Object)specs, (Object)CollectionsKt.emptyList());
            } else {
                Iterable $this$partition$iv = specs;
                boolean $i$f$partition = false;
                ArrayList first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv : $this$partition$iv) {
                    KClass it = (KClass)element$iv;
                    boolean bl2 = false;
                    if (TestEngineKt.isDoNotParallelize(it)) {
                        first$iv.add(element$iv);
                        continue;
                    }
                    second$iv.add(element$iv);
                }
                pair = new Pair(first$iv, second$iv);
            }
            Pair pair2 = pair;
            List list = (List)pair2.component1();
            List parallel = (List)pair2.component2();
            this.submitBatch(parallel, this.parallelism);
            this.submitBatch((List<? extends KClass<? extends Spec>>)single, 1);
            Unit unit2 = unit = Unit.INSTANCE;
            try_ = (Try)new Try.Success((Object)unit2);
        }
        catch (Throwable e$iv) {
            if (!NonFatal.INSTANCE.invoke(e$iv)) {
                throw e$iv;
            }
            try_ = (Try)new Try.Failure(e$iv);
        }
        return try_;
    }

    private final void submitBatch(List<? extends KClass<? extends Spec>> specs, int parallelism) {
        InterruptedException interruptedException;
        ExecutorService executor = Executors.newFixedThreadPool(parallelism, new NamedThreadFactory("kotlintest-engine-%d"));
        Iterable $this$forEach$iv = specs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KClass it = (KClass)element$iv;
            boolean bl = false;
            ExecutorService executorService = executor;
            Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"executor");
            this.submitSpec((KClass<? extends Spec>)it, executorService);
        }
        executor.shutdown();
        this.logger.trace("Waiting for spec execution to terminate");
        try {
            executor.awaitTermination(1L, TimeUnit.DAYS);
            interruptedException = null;
        }
        catch (InterruptedException t) {
            interruptedException = t;
        }
        InterruptedException error = interruptedException;
        if (error != null) {
            throw (Throwable)error;
        }
    }

    private final Try<Unit> end(Throwable t) {
        Try try_;
        Try.Companion this_$iv = Try.Companion;
        try {
            Unit unit;
            boolean bl = false;
            if (t != null) {
                this.logger.error("Error during test engine run", t);
                t.printStackTrace();
            }
            this.listener.engineFinished(t);
            Unit unit2 = unit = Unit.INSTANCE;
            try_ = (Try)new Try.Success((Object)unit2);
        }
        catch (Throwable e$iv) {
            if (!NonFatal.INSTANCE.invoke(e$iv)) {
                throw e$iv;
            }
            try_ = (Try)new Try.Failure(e$iv);
        }
        return try_;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void execute() {
        Try<Unit> try_;
        Try try_2;
        Try this_$iv = this.start();
        Try try_3 = this_$iv;
        if (try_3 instanceof Try.Failure) {
            try_2 = this_$iv;
        } else {
            Kind $receiver$iv$iv;
            if (!(try_3 instanceof Try.Success)) throw new NoWhenBranchMatchedException();
            Unit unit = (Unit)((Try.Success)this_$iv).getValue();
            boolean bl = false;
            Kind kind = $receiver$iv$iv = (Kind)this.submitAll();
            if (kind == null) {
                throw new TypeCastException("null cannot be cast to non-null type arrow.core.Try<A>");
            }
            try_2 = (Try)kind;
        }
        this_$iv = try_2;
        try_3 = this_$iv;
        if (try_3 instanceof Try.Failure) {
            Throwable throwable = ((Try.Failure)this_$iv).getException();
            boolean bl = false;
            this.afterAll();
            try_ = this.end(throwable);
            return;
        } else {
            if (!(try_3 instanceof Try.Success)) throw new NoWhenBranchMatchedException();
            Unit unit = (Unit)((Try.Success)this_$iv).getValue();
            boolean bl = false;
            Try<Unit> this_$iv2 = this.afterAll();
            Try<Unit> try_4 = this_$iv2;
            if (try_4 instanceof Try.Failure) {
                Throwable t = ((Try.Failure)this_$iv2).getException();
                boolean bl2 = false;
                try_ = this.end(t);
                return;
            } else {
                if (!(try_4 instanceof Try.Success)) throw new NoWhenBranchMatchedException();
                Unit it = (Unit)((Try.Success)this_$iv2).getValue();
                boolean bl3 = false;
                try_ = this.end(null);
            }
        }
    }

    private final void submitSpec(KClass<? extends Spec> klass, ExecutorService executor) {
        executor.submit(new Runnable(this, klass, executor){
            final /* synthetic */ TestEngine this$0;
            final /* synthetic */ KClass $klass;
            final /* synthetic */ ExecutorService $executor;

            public final void run() {
                Try this_$iv = TestEngine.access$createSpec(this.this$0, this.$klass);
                Try try_ = this_$iv;
                if (try_ instanceof Try.Failure) {
                    Throwable t = ((Try.Failure)this_$iv).getException();
                    boolean bl = false;
                    this.this$0.getListener().specInitialisationFailed((KClass<? extends Spec>)this.$klass, t);
                    this.$executor.shutdownNow();
                } else if (try_ instanceof Try.Success) {
                    Spec spec = (Spec)((Try.Success)this_$iv).getValue();
                    boolean bl = false;
                    TryfuncsKt.onFailure(TestEngine.access$getSpecExecutor$p(this.this$0).execute(spec), (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this){
                        final /* synthetic */ submitSpec.1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }

                        public final void invoke(@NotNull Throwable t) {
                            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                            this.this$0.this$0.getListener().specInitialisationFailed((KClass<? extends Spec>)this.this$0.$klass, t);
                            this.this$0.$executor.shutdownNow();
                        }
                    }));
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            {
                this.this$0 = testEngine;
                this.$klass = kClass;
                this.$executor = executorService;
            }
        });
    }

    private final Try<Spec> createSpec(KClass<? extends Spec> klass) {
        Try try_;
        Try this_$iv = JvmKt.instantiateSpec(klass);
        Try try_2 = this_$iv;
        if (try_2 instanceof Try.Failure) {
            try_ = this_$iv;
        } else if (try_2 instanceof Try.Success) {
            Try try_3;
            Spec it = (Spec)((Try.Success)this_$iv).getValue();
            boolean bl = false;
            Try.Companion this_$iv2 = Try.Companion;
            try {
                Spec spec;
                boolean bl2 = false;
                this.listener.specCreated(it);
                Spec spec2 = spec = it;
                try_3 = (Try)new Try.Success((Object)spec2);
            }
            catch (Throwable e$iv) {
                if (!NonFatal.INSTANCE.invoke(e$iv)) {
                    throw e$iv;
                }
                try_3 = (Try)new Try.Failure(e$iv);
            }
            Kind $receiver$iv$iv = (Kind)try_3;
            try_ = (Try)$receiver$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return try_;
    }

    @NotNull
    public final List<KClass<? extends Spec>> getClasses() {
        return this.classes;
    }

    public final int getParallelism() {
        return this.parallelism;
    }

    @NotNull
    public final TestEngineListener getListener() {
        return this.listener;
    }

    public TestEngine(@NotNull List<? extends KClass<? extends Spec>> classes, @NotNull List<? extends TestCaseFilter> filters, int parallelism, @NotNull TestEngineListener listener) {
        Intrinsics.checkParameterIsNotNull(classes, (String)"classes");
        Intrinsics.checkParameterIsNotNull(filters, (String)"filters");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.classes = classes;
        this.parallelism = parallelism;
        this.listener = listener;
        this.logger = LoggerFactory.getLogger(this.getClass());
        ScheduledExecutorService scheduledExecutorService = this.scheduler = Executors.newSingleThreadScheduledExecutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)scheduledExecutorService, (String)"scheduler");
        this.specExecutor = new SpecExecutor(this.listener, scheduledExecutorService);
        Project.INSTANCE.registerTestCaseFilter(filters);
    }

    public static final /* synthetic */ Try access$createSpec(TestEngine $this, KClass klass) {
        return $this.createSpec((KClass<? extends Spec>)klass);
    }

    public static final /* synthetic */ SpecExecutor access$getSpecExecutor$p(TestEngine $this) {
        return $this.specExecutor;
    }
}

